% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plot.R
\docType{methods}
\name{plot}
\alias{plot}
\alias{plot,CompositionMatrix,missing-method}
\title{Plot Compositional Data}
\usage{
\S4method{plot}{CompositionMatrix,missing}(x, ..., margin = NULL)
}
\arguments{
\item{x}{A \code{\linkS4class{CompositionMatrix}} object.}

\item{...}{Further \link[graphics:par]{graphical parameters}.}

\item{margin}{A \code{\link{character}} string or an \code{\link{integer}} giving the index of
the column to be used as the third part of the ternary plots. If \code{NULL}
(the default), marginal compositions will be used (i.e. the geometric mean
of the non-selected parts).}
}
\value{
\code{plot()} is called for its side-effects: is results in a graphic being
displayed (invisibly return \code{x}).
}
\description{
Displays a matrix of ternary plots.
}
\examples{
## Data from Aitchison 1986
data("hongite")

## Coerce to compositional data
coda <- as_composition(hongite)

## Ternary plots
plot(coda)
}
\seealso{
\code{\link[isopleuros:ternary_pairs]{isopleuros::ternary_pairs()}}, \code{\link[isopleuros:ternary_plot]{isopleuros::ternary_plot()}}

Other plot methods: 
\code{\link{as_graph}()},
\code{\link{barplot}()},
\code{\link{hist}()},
\code{\link{plot_logratio}}
}
\author{
N. Frerebeau
}
\concept{plot methods}
