% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_database_functions.R
\name{update_db}
\alias{update_db}
\title{Update or create a nflfastR play by play database}
\usage{
update_db(
  dbdir = ".",
  dbname = "pbp_db",
  tblname = "nflfastR_pbp",
  force_rebuild = FALSE
)
}
\arguments{
\item{dbdir}{Directory in which the database is or shall be located}

\item{dbname}{File name of an existing or desired SQLite database within \code{dbdir}}

\item{tblname}{The name of the play by play data table within the database}

\item{force_rebuild}{Logical parameter to rebuild the play by play data table
within the database from scratch in case the cleaned data were updated}
}
\description{
\code{update_db} updates or creates a SQLite database with \code{nflfastR}
play by play data of all completed games since 1999.
}
\details{
This function creates and updates a data table with the name \code{tblname}
within a SQLite database located in \code{dbdir} and named \code{dbname}.
The data table combines all play by play data for every available game back
to the 1999 season and adds the most recent completed games as soon as they
are available for \code{nflfastR}.
The \code{force_rebuild} parameter controls if the data table within the
database (not the database itself because there might be other data in it)
should be removed and rebuilt from scratch (mostly because of bugfixes in
nflfastR or its underlying data)
}
