% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_add_xyac.R
\name{add_xyac}
\alias{add_xyac}
\title{Add expected yards after completion (xyac) variables}
\usage{
add_xyac(pbp)
}
\arguments{
\item{pbp}{is a Data frame of play-by-play data scraped using \code{\link{fast_scraper}}.}
}
\value{
The input Data Frame of the parameter 'pbp' with the following columns
added:
\describe{
\item{xyac_epa}{Expected value of EPA gained after the catch, starting from where the catch was made. Zero yards after the catch would be listed as zero EPA.}
\item{xyac_success}{Probability play earns positive EPA (relative to where play started) based on where ball was caught.}
\item{xyac_fd}{Probability play earns a first down based on where the ball was caught.}
\item{xyac_mean_yardage}{Average expected yards after the catch based on where the ball was caught.}
\item{xyac_median_yardage}{Median expected yards after the catch based on where the ball was caught.}
}
}
\description{
Add expected yards after completion (xyac) variables
}
\details{
Build columns that capture what we should expect after the catch.
}
