% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save_raw_pbp.R
\name{missing_raw_pbp}
\alias{missing_raw_pbp}
\title{Compute Missing Raw PBP Data on Local Filesystem}
\usage{
missing_raw_pbp(
  dir = getOption("nflfastR.raw_directory", default = NULL),
  verbose = TRUE
)
}
\arguments{
\item{dir}{Path to local directory (defaults to option "nflfastR.raw_directory").
nflfastR will download the raw game files split by season into one sub
directory per season.}

\item{verbose}{If \code{TRUE}, will print number of missing game files as well as
oldest and most recent missing ID to console.}
}
\value{
A character vector of missing game IDs. If no files are missing,
returns \code{NULL} invisibly.
}
\description{
Uses \code{\link[nflreadr:load_schedules]{nflreadr::load_schedules()}} to load game IDs of finished games and
compares these IDs to all files saved under \code{dir}.
This function is intended to serve as input for \code{\link[=save_raw_pbp]{save_raw_pbp()}}.
}
\examples{
\donttest{
try(
missing <- missing_raw_pbp(tempdir())
)
}
}
\seealso{
\code{\link[=save_raw_pbp]{save_raw_pbp()}}
}
