% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_nflverse.R
\name{load_pfr_advstats}
\alias{load_pfr_advstats}
\title{Load Advanced Stats from PFR}
\usage{
load_pfr_advstats(
  seasons = most_recent_season(),
  stat_type = c("pass", "rush", "rec", "def"),
  summary_level = c("week", "season")
)
}
\arguments{
\item{seasons}{a numeric vector specifying what seasons to return, if \code{TRUE} returns all available data}

\item{stat_type}{one of "pass", "rush", "rec", "def"}

\item{summary_level}{one of "week" (default) or "season" - some data is only available at the season level}
}
\value{
A tibble of player statistics provided by Pro Football Reference that supplements data in nflverse
}
\description{
Loads player level season stats provided by Pro Football Reference
starting with the 2018 season, primarily to augment existing nflverse data.
}
\examples{
\donttest{
  load_pfr_advstats()
}

}
\seealso{
\url{https://nflreadr.nflverse.com/articles/dictionary_pfr_passing.html} for the web data dictionary

\url{https://www.pro-football-reference.com/years/2021/passing_advanced.htm}

Issues with this data should be filed here: \url{https://github.com/nflverse/nflverse-data}
}
