% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_nextgen_stats.R
\name{load_nextgen_stats}
\alias{load_nextgen_stats}
\title{Load Player Level Weekly NFL Next Gen Stats}
\usage{
load_nextgen_stats(
  seasons = TRUE,
  stat_type = c("passing", "receiving", "rushing"),
  file_type = getOption("nflreadr.prefer", default = "rds")
)
}
\arguments{
\item{seasons}{a numeric vector specifying what seasons to return, if \code{TRUE} returns all available data}

\item{stat_type}{one of \code{"passing"}, \code{"receiving"}, or \code{"rushing"}}

\item{file_type}{One of \code{c("rds", "qs", "csv", "parquet")}. Can also be set globally with
\code{options(nflreadr.prefer)}}
}
\value{
A tibble of week-level player statistics provided by NFL Next Gen Stats.
Regular season summary is given for \code{week == 0}.
}
\description{
Loads player level weekly stats provided by NFL Next Gen Stats
starting with the 2016 season. Three different stat types are available and
the current season's data updates every night. NGS will only provide data for
players above a minimum number of pass/rush/rec attempts.
}
\examples{
\donttest{
try({ # prevents cran errors
  load_nextgen_stats(stat_type = "passing")
  load_nextgen_stats(stat_type = "receiving")
  load_nextgen_stats(stat_type = "rushing")
})
}

}
\seealso{
\url{https://nextgenstats.nfl.com/stats/passing} for \code{stat_type = "passing"}

\url{https://nextgenstats.nfl.com/stats/receiving} for \code{stat_type = "receiving"}

\url{https://nextgenstats.nfl.com/stats/rushing} for \code{stat_type = "rushing"}

\url{https://nflreadr.nflverse.com/articles/dictionary_nextgen_stats.html} for a web version of the data dictionary

\code{\link{dictionary_nextgen_stats}} for the data dictionary as bundled within the package

Issues with this data should be filed here: \url{https://github.com/nflverse/nflverse-data}
}
