% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_draft_picks.R
\name{load_draft_picks}
\alias{load_draft_picks}
\title{Load Draft Picks from PFR}
\usage{
load_draft_picks(
  seasons = TRUE,
  file_type = getOption("nflreadr.prefer", default = "rds")
)
}
\arguments{
\item{seasons}{a numeric vector of seasons to return, default \code{TRUE} returns all available data}

\item{file_type}{One of \code{c("rds", "qs", "csv", "parquet")}. Can also be set globally with
\code{options(nflreadr.prefer)}}
}
\value{
A tibble of NFL draft picks provided by Pro Football Reference.
}
\description{
Loads every draft pick since 1980 courtesy of PFR.
}
\examples{
\dontshow{.for_cran()}
\donttest{
try({ # prevents cran errors
  load_draft_picks()
})
}

}
\seealso{
\url{https://nflreadr.nflverse.com/articles/dictionary_draft_picks.html} for the web data dictionary

\code{\link{dictionary_draft_picks}} for the data dictionary as bundled within the package

Issues with this data should be filed here: \url{https://github.com/nflverse/nflverse-data}
}
