% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset_nhdplus.R
\name{stage_national_data}
\alias{stage_national_data}
\title{Stage NHDPlus National Data (deprecated)}
\usage{
stage_national_data(
  include = c("attribute", "flowline", "catchment"),
  output_path = NULL,
  nhdplus_data = NULL,
  simplified = TRUE
)
}
\arguments{
\item{include}{character vector containing one or more of:
"attributes", "flowline", "catchment".}

\item{output_path}{character path to save the output to defaults
to the directory of the nhdplus_data.}

\item{nhdplus_data}{character path to the .gpkg or .gdb
containing the national seamless dataset. Not required if
\code{\link{nhdplus_path}} has been set.}

\item{simplified}{boolean if TRUE (the default) the CatchmentSP layer
will be included.}
}
\value{
list containing paths to the .rds files.
}
\description{
Breaks down the national geo database into a collection
of quick to access R binary files.
}
\details{
"attributes" will save `NHDFlowline_Network` attributes
as a separate data.frame without the geometry. The others will save
the `NHDFlowline_Network` and `Catchment` or `CatchmentSP`
(per the `simplified` parameter) as sf data.frames with
superfluous Z information dropped.

The returned list of paths is also added to the nhdplusTools_env
as "national_data".
}
\examples{

source(system.file("extdata/sample_data.R", package = "nhdplusTools"))

stage_national_data(nhdplus_data = sample_data, output_path = tempdir())

}
