% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw.R
\name{draw}
\alias{draw}
\title{Generic function for simulating from NHPPPs given the intensity function
or the cumulative intensity function.}
\usage{
draw(
  Lambda = NULL,
  Lambda_inv = NULL,
  lambda = NULL,
  line_majorizer_intercept = NULL,
  line_majorizer_slope = NULL,
  line_majorizer_is_loglinear = FALSE,
  step_majorizer_vector = NULL,
  t_min = NULL,
  t_max = NULL,
  atmost1 = FALSE,
  atleast1 = FALSE
)
}
\arguments{
\item{Lambda}{(function, double vector) the integrated (cumulative) rate of the NHPPP}

\item{Lambda_inv}{(function, double vector) the inverse of `Lambda()'}

\item{lambda}{(function) the instantaneous rate}

\item{line_majorizer_intercept}{The intercept \code{alpha} of the \link{log}linear majorizer function: \code{alpha + beta * t} or \code{exp(alpha + beta * t)}}

\item{line_majorizer_slope}{The slope \code{beta} of the \link{log}linear majorizer function: \code{alpha + beta * t} or \code{exp(alpha + beta * t)}}

\item{line_majorizer_is_loglinear}{(boolean) if \code{TRUE} the majorizer is loglinear \code{exp(alpha + beta * t)}; if \code{FALSE} it is a linear function}

\item{step_majorizer_vector}{(vector, double) \code{K} constant majorizing rates, one per interval; all intervals are of equal length (regular)}

\item{t_min}{(double) the lower bound of the interval}

\item{t_max}{(double) the upper bound of the interval}

\item{atmost1}{boolean, draw at most 1 event time}

\item{atleast1}{boolean, draw at least 1 event time in interval}
}
\value{
a vector of event times
}
\description{
This is a wrapper to the package's specific functions, and thus somewhat slower.
For time-intensive simulations prefer one of the specific functions.
}
