% Generated by roxygen2 (4.0.1): do not edit by hand
\name{niw.mom}
\alias{niw.mom}
\title{Mean and variance of the Normal-Inverse-Wishart distribution.}
\usage{
niw.mom(lambda, kappa, Psi, nu)
}
\arguments{
\item{lambda}{location parameter. See Details.}

\item{kappa}{scale parameter. See Details.}

\item{Psi}{scale matrix.  See Details}

\item{nu}{degrees of freedom.  See Details.}
}
\value{
Returns a list with elements \code{mu} and \code{Sigma}, each containing lists with
elements \code{mean} and \code{var}.  For \code{mu} these elements are of size \code{length(lambda)}
and \code{c(length(lambda),length(lambda))}.  For \code{Sigma} they are of size \code{dim(Psi)}
and \code{c(dim(Psi), dim(Psi))}, such that cov\eqn{(\Sigma_{ij}, \Sigma_{kl})=}\code{Sigma$var[i,j,k,l]}.
}
\description{
This function computes the mean and variance of the Normal-Inverse-Wishart (NIW)
distribution.  Can be used to very quickly compute Bayesian point estimates for the conjugate
NIW prior.
}
\details{
The NIW distribution \eqn{p(\mu, \Sigma | \lambda, \kappa, \Psi, \nu)} is defined as
\deqn{\Sigma \sim W^{-1}(\Psi, \nu), \quad \mu | \Sigma \sim N(\lambda, \Sigma/\kappa).}
Note that cov\eqn{(\mu, \Sigma) = 0}.
}
\examples{
# NIW parameters
d <- 3 # number of dimensions
lambda <- rnorm(d)
kappa <- 2
Psi <- crossprod(matrix(rnorm(d^2), d, d))
nu <- 10

# simulate data
niw.sim <- rniw(n = 1e4, lambda, kappa, Psi, nu)

# check moments
niw.mV <- niw.mom(lambda, kappa, Psi, nu)

# mean of mu
ii <- 1
c(true = niw.mV$mu$mean[ii], sim = mean(niw.sim$mu[,ii]))

# variance of Sigma
II <- c(1,2)
JJ <- c(2,3)
c(true = niw.mV$var[II[1],II[2],JJ[1],JJ[2]],
 sim = cov(niw.sim$Sigma[II[1],II[2],], niw.sim$Sigma[JJ[1],JJ[2],]))
}
\seealso{
\code{\link{rniw}}, \code{\link{niw.coeffs}}, \code{\link{niw.post}}.
}

