% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ref_oli.R
\name{ref_oli}
\alias{ref_oli}
\title{Reflectance Landsat OLI}
\usage{
ref_oli(x, sun.elev)
}
\arguments{
\item{x}{A raster stack containing the first seven Landsat OLI bands.}

\item{sun.elev}{Sun elevation angle in degrees.}
}
\value{
A raster layer object with the Top of atmosphere planetary reflectance.
}
\description{
This function convert Digital Numbers to TOA Reflectance using the rescaling coefficients in the MTL file.
}
\examples{
library(raster)
path_files <- system.file("extdata/", package="nightmares")
x <- stack(list.files(path_files,".tif", full.names=TRUE))
ref_oli(x, 67.97)
ref_oli(x, sun.elev=67.97)

}
\references{
\url{https://www.usgs.gov/land-resources/nli/landsat/using-usgs-landsat-level-1-data-product}.
}
