% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/types_modelValues.R
\name{modelValues}
\alias{modelValues}
\title{Create a NIMBLE modelValues Object}
\usage{
modelValues(conf, m = 1)
}
\arguments{
\item{conf}{An object which includes information for building modelValues. Can either be a NIMBLE model (see \code{help(modelBaseClass)})
or the object returned from \code{modelValuesConf}}

\item{m}{The number of rows to create in the modelValues object.  Can later be changed with \code{resize}}
}
\description{
Builds modelValues object from a model values configuration object, which can include a NIMBLE model
}
\details{
See the User Manual or \code{help(modelValuesBaseClass)} for information about manipulating NIMBLE modelValues object returned by this function
}
\examples{
#From model object:
code <- nimbleCode({
 a ~ dnorm(0,1)
 for(i in 1:3){
		for(j in 1:3)
			b[i,j] ~ dnorm(0,1)
		}
})
Rmodel <- nimbleModel(code)
Rmodel_mv <- modelValues(Rmodel, m = 2)
	#Custom modelValues object:
mvConf <- modelValuesConf(vars = c('x', 'y'),
             types = c('double', 'int'),
             sizes = list(x = 3, y = c(2,2)))
custom_mv <- modelValues(mvConf, m = 2)
custom_mv['y',]
}
\author{
NIMBLE development team
}

