% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nixtla_client_cross_validation.R
\name{nixtla_client_cross_validation}
\alias{nixtla_client_cross_validation}
\title{Sequential version of 'nixtla_client_cross_validation'
This is a private function of 'nixtlar'}
\usage{
nixtla_client_cross_validation(
  df,
  h = 8,
  freq = NULL,
  id_col = "unique_id",
  time_col = "ds",
  target_col = "y",
  level = NULL,
  quantiles = NULL,
  n_windows = 1,
  step_size = NULL,
  finetune_steps = 0,
  finetune_loss = "default",
  clean_ex_first = TRUE,
  model = "timegpt-1"
)
}
\arguments{
\item{df}{A data frame with time series data.}

\item{h}{Forecast horizon.}

\item{freq}{Frequency of the data.}

\item{id_col}{Column that identifies each series.}

\item{time_col}{Column that identifies each timestep.}

\item{target_col}{Column that contains the target variable.}

\item{level}{The confidence levels (0-100) for the prediction intervals.}

\item{quantiles}{Quantiles to forecast. Should be between 0 and 1.}

\item{n_windows}{Number of windows to evaluate.}

\item{step_size}{Step size between each cross validation window. If NULL, it will equal the forecast horizon (h).}

\item{finetune_steps}{Number of steps used to finetune 'TimeGPT' in the new data.}

\item{finetune_loss}{Loss function to use for finetuning. Options are: "default", "mae", "mse", "rmse", "mape", and "smape".}

\item{clean_ex_first}{Clean exogenous signal before making the forecasts using 'TimeGPT'.}

\item{model}{Model to use, either "timegpt-1" or "timegpt-1-long-horizon". Use "timegpt-1-long-horizon" if you want to forecast more than one seasonal period given the frequency of the data.}
}
\value{
A data frame with 'TimeGPT''s cross validation result.
}
\description{
Sequential version of 'nixtla_client_cross_validation'
This is a private function of 'nixtlar'
}
\examples{
\dontrun{
  nixtlar::nixtla_set_api_key("YOUR_API_KEY")
  df <- nixtlar::electricity
  fcst <- nixtlar::nixtla_client_cross_validation(df, h = 8, id_col = "unique_id", n_windows = 5)
}

}
\keyword{internal}
