% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/focei_fit.R
\name{fitted.focei.fit}
\alias{fitted.focei.fit}
\title{Extract the fitted values from the model}
\usage{
\method{fitted}{focei.fit}(object, ..., population = FALSE,
  type = c("fitted", "Vi", "Vfo", "dErr_dEta", "dR_dEta", "posthoc"))
}
\arguments{
\item{object}{Fit object}

\item{...}{other parameters}

\item{population}{when true (default false), calculate the
    population predictions; When false, calculate the individual
    predictions.

    If this is a matrix with the number columns equal to the
    number of ETAs in model, and the number of rows equals to the
    number of subjects in the dataset, then these etas will be
    used to fit the data.}

\item{type}{The type of fitted object to be extracted.  When the
value is "fitted", this gives the individual or population
fitted values. The "Vi" option gives the variance estimate for
the individual.  The "Vfo" gives the Variance under the fo
assumption when population=FALSE, and the FOCE assumption when
population=TRUE. "dErr_dEta" gives the df/deta*eta. When
"posthoc", this extracts the posthoc deviations from the
typical values or ETAs.}
}
\value{
Individual/population predictions
}
\description{
Extract the fitted values from the model
}
\author{
Matthew L. Fidler
}
