% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{nlmixrAugPred}
\alias{nlmixrAugPred}
\alias{augPred.focei.fit}
\title{Augmented Prediction for nlmixr fit}
\usage{
nlmixrAugPred(object, ..., covs_interpolation = c("linear", "locf", "nocb",
  "midpoint"), primary = NULL, minimum = NULL, maximum = NULL,
  length.out = 51L)

\method{augPred}{focei.fit}(object, primary = NULL, minimum = min(primary),
  maximum = max(primary), length.out = 51, ...)
}
\arguments{
\item{object}{Nlmixr fit object}

\item{...}{some methods for the generic may require additional
   arguments.}

\item{covs_interpolation}{specifies the interpolation method for
    time-varying covariates. When solving ODEs it often samples
    times outside the sampling time specified in \code{events}.
    When this happens, the time varying covariates are
    interpolated.  Currently this can be:

\itemize{
\item \code{"linear"} interpolation (the default), which interpolates the covariate
    by solving the line between the observed covariates and extrapolating the new
    covariate value.
\item \code{"constant"} -- Last observation carried forward.
\item \code{"NOCB"} -- Next Observation Carried Backward.  This is the same method
      that NONMEM uses.
\item \code{"midpoint"} Last observation carried forward to midpoint; Next observation
  carried backward to midpoint.
}}

\item{primary}{an optional one-sided formula specifying the primary
   covariate to be used to generate the augmented predictions. By
   default, if a  covariate can be extracted from the data used to generate
   \code{object} (using \code{getCovariate}), it will be used as
   \code{primary}.}

\item{minimum}{an optional lower limit for the primary
   covariate. Defaults to \code{min(primary)}.}

\item{maximum}{an optional upper limit for the primary
   covariate. Defaults to \code{max(primary)}.}

\item{length.out}{an optional integer with the number of primary
   covariate values at which to evaluate the predictions.  Defaults to
   51.}
}
\value{
Stacked data.frame with observations, individual/population predictions.
}
\description{
Augmented Prediction for nlmixr fit
}
\author{
Matthew L. Fidler
}
