% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abline_range.R
\name{abline_range}
\alias{abline_range}
\title{Add a line to a plot}
\usage{
abline_range(a = NULL, b = NULL, reg = NULL, from = NULL, to = NULL,
  ...)
}
\arguments{
\item{a}{Intercept (optional)}

\item{b}{Slope (optional)}

\item{reg}{A fitted linear regression model (output of \code{\link{lm}}).}

\item{from}{Draw from this X value}

\item{to}{Draw to this x value}

\item{\dots}{Further parameters passed to \code{\link{segments}}}
}
\description{
As \code{abline}, but with \code{from} and \code{to} arguments.
If a fitted linear regression model is used as asn argument, it uses the min and max values of the data used to fit the model.
}
\examples{

# Add a line manually
with(mtcars, plot(1/wt, mpg, xlim=c(0,0.8), ylim=c(0,40)))
abline_range(0,50,from=0.2, to=0.6)

# Add a line across the range of the data from a regression object
with(mtcars, plot(1/wt, mpg, xlim=c(0,0.8), ylim=c(0,40)))
fit <- lm(mpg ~ I(1/wt), data=mtcars)
abline_range(fit)

}
\seealso{
See \code{\link{add_regres_line}} for adding a regression line with a confidence interval
}

