% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlsic.R
\name{lsi_ln}
\alias{lsi_ln}
\title{Linear Least Squares with Inequality constraints, least norm solution}
\usage{
lsi_ln(a, b, u = NULL, co = NULL, rcond = 1e+10, mnorm = NULL, x0 = NULL)
}
\arguments{
\item{a}{dense matrix A or its QR decomposition}

\item{b}{right hand side vector}

\item{u}{dense matrix of inequality constraints}

\item{co}{right hand side vector of inequality constraints}

\item{rcond}{maximal condition number for determining rank deficient matrix}

\item{mnorm}{norm matrix (can be dense or sparse) for which \code{\%*\%} operation with a dense vector is defined}

\item{x0}{optional vector from which a least norm distance is searched for}
}
\value{
solution vector whose attribute 'mes' may contain a message about possible numerical problems
}
\description{
solve linear least square problem \code{min_x ||A*x-b||}
with inequality constraints \code{u\%*\%x >= co}
If A is rank deficient, least norm solution \code{||mnorm\%*\%(x-x0)||} is used.
If the parameter mnorm is NULL, it is treated as an identity matrix.
If the vector x0 is NULL, it is treated as 0 vector.
}
\seealso{
\link{lsi}, \link{ldp}, \link[base:qr]{base::qr}
}
