% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{loglik_mult}
\alias{loglik_mult}
\title{Extract log-likelihood from a mixture of multinomials}
\usage{
loglik_mult(X, Theta, Lambda = NULL, p)
}
\arguments{
\item{X}{a matrix of dimension \code{N} (number of observation) \code{x M} (number of variables) containing multinomials observations.}

\item{Theta}{matrix of dimension \code{M x H}.}

\item{Lambda}{matrix of dimension \code{H x K}. Can be \code{NULL}.}

\item{p}{vector containing the proportions of each cluster. Must be of dimension \code{K} (or \code{H} if \code{Lambda} is \code{NULL}).}
}
\value{
The function returns the log-likelihood of the data to the model
}
\description{
Extract log-likelihood from a mixture of multinomials
}
\examples{
travelers <- travelers[ ,-1]
M <- ncol(travelers)
K <- 5

Theta0    <- t(dplyr::sample_n(travelers, K))
Theta0    <- Theta0 / matrix(rep(apply(Theta0, 2, sum), M), nrow = M, ncol = K, byrow = TRUE)
travelers <- as.matrix(travelers)
p0        <- rep(1 / K, K)

llh <- loglik_mult(travelers, Theta0, p = p0)
llh

}
