% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/000functions.R
\name{convert_attr2exp}
\alias{convert_attr2exp}
\title{\code{convert_attr2exp} converts symbolic attribute of derivative into expression object.}
\usage{
convert_attr2exp(obj)
}
\arguments{
\item{obj}{Symbolic expression of gradient or hessian}
}
\value{
combine expression of derivatives
}
\description{
\code{convert_attr2exp} converts symbolic attribute of derivative into expression object.
}
\examples{
eq1 <- parse(text="2*(log(sin(x)/log(x)))+x^4*log(x)+cos(y+x)")
tt1 <- deriv(eq1, c("x", "y"), hessian=TRUE)
r1 <- convert_attr2exp(extract_attr_deriv(tt1, "grad"))
r2 <- convert_attr2exp(extract_attr_deriv(tt1, "hessian"))
}
