% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flic.R
\encoding{UTF-8}
\name{flic}
\alias{flic}
\alias{flic.formula}
\alias{flic.logistf}
\title{FLIC - Firth's logistic regression with intercept correction}
\usage{
flic(...)

\method{flic}{formula}(formula, data, model = TRUE, ...)

\method{flic}{logistf}(lfobject, model = TRUE, ...)
}
\arguments{
\item{...}{Further arguments passed to the method or \code{\link{logistf}}-call.}

\item{formula}{A formula object, with the response on the left of the operator, 
and the model terms on the right. The response must be a vector with 0 and 1 or \code{FALSE} and 
\code{TRUE} for the outcome, where the higher value (1 or \code{TRUE}) is modeled.}

\item{data}{If using with formula, a data frame containing the variables in the model.}

\item{model}{If TRUE the corresponding components of the fit are returned.}

\item{lfobject}{A fitted \code{\link{logistf}} object}
}
\value{
A \code{flic} object with components:
  \item{coefficients}{The coefficients of the parameter in the fitted model.}
  \item{predict}{A vector with the predicted probability of each observation}
  \item{linear.predictors}{A vector with the linear predictor of each observation.}
  \item{var}{The variance-covariance-matrix of the parameters.}
  \item{prob}{The p-values of the specific parameters}
  \item{ci.lower}{The lower confidence limits of the parameter.}
  \item{ci.upper}{The upper confidence limits of the parameter.}
  \item{call}{The call object.}
  \item{alpha}{The significance level: 0.95}
  \item{method}{depending on the fitting method 'Penalized ML' or `Standard ML'.}
  \item{method.ci}{the method in calculating the confidence intervals, i.e. `profile likelihood' or `Wald', depending on the argument pl and plconf.}
  \item{df}{The number of degrees of freedom in the model.}
  \item{loglik}{A vector of the (penalized) log-likelihood of the restricted and the full models.}
  \item{n}{The number of observations.}
  \item{formula}{The formula object.}
  \item{control}{a copy of the control parameters.}  
  \item{terms}{the model terms (column names of design matrix).}
  \item{model}{if requested (the default), the model frame used.}
}
\description{
\code{flic} implements Firth's bias-Reduced penalized-likelihood logistic regression with intercept correction.
}
\details{
Flic is a simple modification of Firth's logistic regression which provides average predicted
probabilities equal to the observed proportion of events, while preserving the ability to deal
with separation.

In general the average predicted probability in FL regression is not equal to the observed 
proportion of events. Because the determinant of the Fisher-Information matrix is maximized 
for \eqn{\pi_i = \frac{1}{2}} it is concluded that Firth's penalization tends to push the 
predicted probabilities towards one-half compared with ML-estimation.
Flic fits a logistic regression model applying Firth's correction to the likelihood with a 
correction of the intercept, such that the predicted probabilities become unbiased while
keeping all other coefficients constant.
The following generic methods are available for flic's output object: \code{print, summary, coef, confint, anova, extractAIC, add1, drop1, 
profile, terms, nobs, predict}. Furthermore, forward and backward functions perform convenient variable selection. Note 
that anova, extractAIC, add1, drop1, forward and backward are based on penalized likelihood 
ratios.
}
\section{Methods (by class)}{
\itemize{
\item \code{flic(formula)}: With formula and data

\item \code{flic(logistf)}: With logistf object

}}
\examples{
#With formula and data:
data(sex2)
flic(case ~ age + oc + vic + vicl + vis + dia, sex2)

#With a logistf object:
lf <- logistf(formula = case ~ age + oc + vic + vicl + vis + dia, data = sex2)
flic(lf)

}
\references{
Puhr, R., Heinze, G., Nold, M., Lusa, L., and Geroldinger, A. (2017) Firth's logistic regression with rare events: accurate effect estimates and predictions?. Statist. Med., 36: 2302-2317. doi: 10.1002/sim.7273.
}
\seealso{
\code{\link{logistf}} for Firth's bias-Reduced penalized-likelihood logistic regression.
}
