% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.r
\name{funs.class.spec}
\alias{funs.class.spec}
\alias{class.spec.ct}
\alias{class.spec}
\title{Class-specific Chi-square Tests based on NNCTs}
\usage{
class.spec.ct(ct, covN, type = "base")

class.spec(dat, lab, type = "base", ...)
}
\arguments{
\item{ct}{A nearest neighbor contingency table, used in \code{class.spec.ct} only}

\item{covN}{The \eqn{k^2 \times k^2} covariance matrix of row-wise vectorized entries of NNCT, \code{ct} ;
used in \code{class.spec.ct} only.}

\item{type}{The type of the class-specific tests with default=\code{"base"}. 
Takes on values\code{"base"} for (Dixon's) base class-specific test
and\code{"NN"} for NN class-specific test.}

\item{dat}{The data set in one or higher dimensions, each row corresponds to a data point,
used in \code{class.spec} only}

\item{lab}{The \code{vector} of class labels (numerical or categorical), used in \code{class.spec} only}

\item{\dots}{are for further arguments, such as \code{method} and \code{p}, passed to the \code{\link[stats]{dist}} function. 
used in \code{class.spec} only}
}
\value{
A \code{list} with the elements
\item{type}{Type of the class-specific test, which is \code{"base"} or \code{"NN"} for this function}
\item{statistic}{The \code{vector} of class-specific test statistics}
\item{stat.names}{Name of the test statistics}
\item{p.value}{The \code{vector} of \eqn{p}-values for the hypothesis test}
\item{df}{Degrees of freedom for the chi-squared test, which is \eqn{k-1} for base class-specific test
and \eqn{k} for NN class-specific test.}
\item{estimate}{Estimates of the parameters, NNCT, i.e., the matrix of the 
observed \eqn{N_{ij}} values for base class-specific test and transpose of the NNCT for
the NN class-specific test.}
\item{null.value}{The \code{matrix} of hypothesized null values for the parameters which are expected values
of the \eqn{N_{ij}} values for the base class-specific test and transpose of this
matrix for the NN-class specific test.}
\item{null.name}{Name of the null values}
\item{method}{Description of the hypothesis test}
\item{ct.name}{Name of the contingency table, \code{ct}, returned by \code{class.spec.ct} only}
\item{data.name}{Name of the data set, \code{dat}, returned by \code{class.spec} only}
}
\description{
Two functions: \code{class.spec.ct} and \code{class.spec}.

Both functions are objects of class \code{"classhtest"} but with different arguments (see the parameter list below).
Each one performs class specific segregation tests for the rows if \code{type="base"} and 
columns if \code{type="NN"} for \eqn{k \ge 2} classes.
That is,
each one performs hypothesis tests of deviations of 
entries in each row (column) of NNCT from the expected values under RL or CSR for each row (column)
if \code{type="base"} (\code{"NN"}). 
Recall that row labels of the NNCT are base class labels and
column labels in the NNCT are NN class labels.
The test for each row (column) \eqn{i} is based on the chi-squared approximation of the corresponding quadratic form
and are due to \insertCite{dixon:NNCTEco2002;textual}{nnspat} 
(\insertCite{ceyhan:stat-neer-class2009;textual}{nnspat}).

The argument \code{covN} must be covariance of row-wise (column-wise) vectorization of NNCT if \code{type="base"}
(\code{type="NN"}).

Each function yields the test statistic, \eqn{p}-value and \code{df} for each base class \eqn{i}, description of the 
alternative with the corresponding null values (i.e. expected values) for the row (column) \eqn{i}, estimates for the entries in 
row (column) \eqn{i} for \eqn{i=1,\ldots,k} if \code{type="base"} (\code{type="NN"}).
The functions also provide names of the test statistics, the method and the data set used.

The null hypothesis for each row (column) is that the corresponding \eqn{N_{ij}} entries in row (column) \eqn{i} are 
equal to their expected values under RL or CSR.

See also (\insertCite{dixon:NNCTEco2002,ceyhan:stat-neer-class2009;textual}{nnspat})
and the references therein.
}
\examples{
n<-20
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:2,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)

W<-Wmat(ipd)
Qv<-Qvec(W)$q
Rv<-Rval(W)
varN<-var.nnct(ct,Qv,Rv)
covN<-cov.nnct(ct,varN,Qv,Rv) #default is byrow

class.spec(Y,cls)
class.spec(Y,cls,type="NN")

class.spec.ct(ct,covN)
class.spec.ct(ct,covN,type="NN")

class.spec(Y,cls,method="max")

#cls as a factor
na<-floor(n/2); nb<-n-na
fcls<-rep(c("a","b"),c(na,nb))
ct<-nnct(ipd,fcls)

class.spec(Y,fcls)
class.spec(Y,fcls,type="NN")

class.spec.ct(ct,covN)
class.spec.ct(ct,covN,type="NN")

#############
n<-40
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:4,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)

W<-Wmat(ipd)
Qv<-Qvec(W)$q
Rv<-Rval(W)
varN<-var.nnct(ct,Qv,Rv)
covN<-cov.nnct(ct,varN,Qv,Rv)

class.spec(Y,cls)
class.spec(Y,cls,type="NN")

class.spec.ct(ct,covN)
class.spec.ct(ct,covN,type="NN")

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{base.class.spec.ct}}, \code{\link{base.class.spec}}, \code{\link{NN.class.spec.ct}} 
and \code{\link{NN.class.spec}}
}
