% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.r
\name{pk}
\alias{pk}
\title{Probability of \code{k} items selected from the class with size \eqn{n_1}}
\usage{
pk(n, n1, k)

pk(n, n1, k)
}
\arguments{
\item{n}{A positive integer representing the number of points in the data set}

\item{n1}{Number of cases}

\item{k}{Integer specifying the number of NNs (of subject \eqn{i})}
}
\value{
Returns the probability of \code{k} items selected from \code{n} items are from the class of interest
(i.e., from the class whose size is \eqn{n_1})

Returns the \eqn{p_k} value. See the description.
}
\description{
Returns the ratio \eqn{n_1(n_1-1) \cdots (n_1-(k-1))/(n(n-1) \cdots (n-(k-1))}, 
which is the probability that the \code{k} selected
objects are from class 1 with size \eqn{n_1} (denoted as \code{n1} as an argument)
and the total data size is \code{n}.
This probability is valid under RL or CSR.

This function computes the \eqn{p_k} value which is required in the computation of the variance
of Cuzick and Edwards \eqn{T_k} test. 
\eqn{p_k} is defined as the ratio \eqn{n_1(n_1-1)\cdots (n_1-(k-1))/(n(n-1)\cdots (n-(k-1))}.

The argument, \eqn{n_1}, is the number of cases (denoted as \code{n1} as an argument).
The number of cases are denoted as \eqn{n_1} and number of controls as \eqn{n_0} in this function
to match the case-control class labeling,
which is just the reverse of the labeling in \insertCite{cuzick:1990;textual}{nnspat}.

See (\insertCite{cuzick:1990;textual}{nnspat}) for more details.
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{p11}} and \code{\link{p12}} etc.

\code{\link{asyvarTk}}, \code{\link{varTk}}, and \code{\link{varTkaij}}
}
\author{
Elvan Ceyhan
}
