% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.r
\name{var.nnct}
\alias{var.nnct}
\title{Variances of Cell Counts in an NNCT}
\usage{
var.nnct(ct, Q, R)
}
\arguments{
\item{ct}{A nearest neighbor contingency table}

\item{Q}{The number of shared NNs}

\item{R}{The number of reflexive NNs (i.e., twice the number of reflexive NN pairs)}
}
\value{
A \code{matrix} of same dimension as, \code{ct}, whose entries are the variances of the cell counts 
in the NNCT with class sizes given as the row sums of \code{ct}. The row and column names are inherited from \code{ct}.
}
\description{
Returns the variances of cell counts \eqn{N_{ij}} for \eqn{i,j=1,\ldots,k} in the NNCT, \code{ct} in matrix form which
is of the same dimension as \code{ct}. These variances are valid under RL or conditional on \eqn{Q} and \eqn{R} under CSR.

See also (\insertCite{dixon:1994,dixon:NNCTEco2002,ceyhan:eest-2010,ceyhan:jkss-posthoc-2017;textual}{nnspat}).
}
\examples{
n<-20  #or try sample(1:20,1)
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:2,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)
ct

W<-Wmat(ipd)
Qv<-Qvec(W)$q
Rv<-Rval(W)
var.nnct(ct,Qv,Rv)

#cls as a factor
na<-floor(n/2); nb<-n-na
fcls<-rep(c("a","b"),c(na,nb))
ct<-nnct(ipd,fcls)
var.nnct(ct,Qv,Rv)

#############
n<-40
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:4,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)

W<-Wmat(ipd)
Qv<-Qvec(W)$q
Rv<-Rval(W)
var.nnct(ct,Qv,Rv)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{var.tct}}, \code{\link{var.nnsym}} and \code{\link{cov.nnct}}
}
\author{
Elvan Ceyhan
}
