% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.R
\name{funsC_MI_II}
\alias{funsC_MI_II}
\alias{correct.cf1}
\alias{correct.cf2}
\title{Correction Matrices for the Covariance Matrix of NNCT entries}
\usage{
correct.cf1(ct)

correct.cf2(ct)
}
\arguments{
\item{ct}{A nearest neighbor contingency table}
}
\value{
Both functions return a correction matrix which is to be multiplied with the covariance matrix of
entries of the NNCT so as to obtain types I and II overall tests from Pielou's test of segregation.
See the description above for further detail.
}
\description{
Two functions: \code{correct.cf1} and \code{correct.cf1}.

Each function yields matrices which are used in obtaining covariance matrices of \eqn{T_{ij}} values for 
types I and II tests from the usual Chi-Square test of contingency tables (i.e. Pielou's test) applied
on NNCTs.
The output matrices are to be term-by-term multiplied with the covariance matrix of 
the entries of NNCT. See Sections 3.1 and 3.2 in 
(\insertCite{ceyhan:SJScorrected2010;textual}{nnspat})
or
Sections 3.5.1 and 3.5.2 in 
(\insertCite{ECarXivCorrected:2008;textual}{nnspat}) for more details.
}
\examples{
n<-20  #or try sample(1:20,1)
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:2,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)

W<-Wmat(ipd)
Qv<-Qvec(W)$q
Rv<-Rval(W)
varN<-var.nnct(ct,Qv,Rv)
covN<-cov.nnct(ct,varN,Qv,Rv)

#correction type 1
CM1<-correct.cf1(ct)
CovN.cf1<-covN*CM1

#correction type 2
CM2<-correct.cf2(ct)
CovN.cf2<-covN*CM2

covN
CovN.cf1
CovN.cf2

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{nnct.cr1}} and \code{\link{nnct.cr2}}
}
\author{
Elvan Ceyhan
}
