% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.R
\name{docdb_get}
\alias{docdb_get}
\title{Get documents}
\usage{
docdb_get(src, key, ...)
}
\arguments{
\item{src}{source object, result of call to src}

\item{key}{(chartacter) A key. ignored for mongo}

\item{...}{Ignored for now}
}
\description{
Get documents
}
\details{
Note that with etcd, you have to prefix a key with a
forward slash.
}
\examples{
\dontrun{
# CouchDB
src <- src_couchdb()
docout <- docdb_create(src, key = "mtcars2", value = mtcars)
docdb_get(src, "mtcars2")

# etcd
# src <- src_etcd()
# docdb_create(src, "/hello", mtcars)
# docdb_get(src, "/hello")

# Elasticsearch
src <- src_elastic()
docdb_create(src, "iris", iris)
docdb_get(src, "iris")

# Redis
src <- src_redis()
docdb_create(src, "mtcars", mtcars)
docdb_get(src, "mtcars")

# Mongo
src <- src_mongo()
docdb_create(src, "mtcars", mtcars)
docdb_get(src, "mtcars")
}
}
