% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list.R
\name{docdb_list}
\alias{docdb_list}
\title{List containers in database}
\usage{
docdb_list(src, ...)
}
\arguments{
\item{src}{Source object, result of call to any of functions
\code{\link[=src_mongo]{src_mongo()}}, \code{\link[=src_sqlite]{src_sqlite()}}, \code{\link[=src_elastic]{src_elastic()}}, \code{\link[=src_couchdb]{src_couchdb()}}
\code{\link[=src_duckdb]{src_duckdb()}} or \code{\link[=src_postgres]{src_postgres()}}}

\item{...}{Passed to function \code{\link[DBI:dbListTables]{DBI::dbListTables()}}}
}
\value{
Vector of names of containers that can be
used as parameter \code{key} with other functions such as
\code{\link[=docdb_create]{docdb_create()}}.
}
\description{
List containers in database
}
\examples{
\dontrun{
src <- src_sqlite()
docdb_create(src, "iris", iris)
docdb_list(src)
}
}
