% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delete.R
\name{docdb_delete}
\alias{docdb_delete}
\title{Delete documents}
\usage{
docdb_delete(src, key, ...)
}
\arguments{
\item{src}{source object, result of call to src, an
object of class \code{docdb_src}}

\item{key}{(character) A key (collection for mongo)}

\item{...}{Ignored for now}
}
\description{
Delete documents
}
\details{
Note that with etcd, you have to prefix a key with a
forward slash.
}
\examples{
\dontrun{
# couchdb
(src <- src_couchdb())
docdb_create(src, "mtcars", mtcars)
docdb_get(src, "mtcars")
docdb_delete(src, "mtcars")

# elasticsearch
src <- src_elastic()
if (docdb_exists(src, "iris")) docdb_delete(src, "iris")
docdb_create(src, "iris", iris)
Sys.sleep(2)
docdb_get(src, "iris")
docdb_delete(src, "iris")

# Redis
src <- src_redis()
docdb_create(src, key = "mtcars", value = mtcars)
docdb_get(src, "mtcars")
docdb_delete(src, "mtcars")

# mongo
src <- src_mongo(collection = "iris")
docdb_create(src, "iris", iris)
docdb_get(src, "iris")
docdb_delete(src, "iris")

# SQLite
src <- src_sqlite()
docdb_create(src, "iris", iris)
docdb_get(src, "iris")
docdb_delete(src, "iris")
}
}
