% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list.R
\name{docdb_list}
\alias{docdb_list}
\title{List containers in database}
\usage{
docdb_list(src, ...)
}
\arguments{
\item{src}{Source object, result of call to any of functions
\code{\link[=src_mongo]{src_mongo()}}, \code{\link[=src_sqlite]{src_sqlite()}}, \code{\link[=src_elastic]{src_elastic()}} or \code{\link[=src_couchdb]{src_couchdb()}}}

\item{...}{Passed to functions:
\itemize{
\item CouchDB: \code{\link[sofa:db_info]{sofa::db_info()}}
\item Elasticsearch: \code{\link[elastic:alias]{elastic::aliases_get()}}
\item MongoDB: ignored
\item RSQLite: ignored
}}
}
\value{
(vector) of names of containers that can be
used as parameter \code{key} with other functions such as
\code{\link[=docdb_create]{docdb_create()}}.
Parameter \code{key} corresponds to \code{collection} for MongoDB,
\code{dbname} for CouchDB, \code{index} for Elasticsearch and
a table name for RSQLite)
}
\description{
List containers in database
}
\examples{
\dontrun{
src <- src_sqlite()
docdb_create(src, "iris", iris)
docdb_list(src)
}
}
