% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/src_sqlite.R
\name{src_sqlite}
\alias{src_sqlite}
\title{Setup a RSQLite database connection}
\usage{
src_sqlite(dbname = ":memory:", ...)
}
\arguments{
\item{dbname}{(character) name of database file,
defaults to ":memory:" for an in-memory database,
see \code{\link[RSQLite:SQLite]{RSQLite::SQLite()}}}

\item{...}{additional named parameters passed
on to \code{\link[RSQLite:SQLite]{RSQLite::SQLite()}}}
}
\value{
A \code{nodbi} source object
}
\description{
Setup a RSQLite database connection
}
\details{
Uses \pkg{RSQLite} as backend. \pkg{nodbi} creates or uses
an SQLite table, with columns \verb{_id} and \code{json} created and used by
package \code{nodbi}, applying SQL functions as per
\url{https://www.sqlite.org/json1.html} to the \code{json} column.
Each row in the table represents a \code{JSON} document.
Any root-level \verb{_id} is extracted from the document(s) and used for
column \verb{_id}, otherwise a UUID is created as \verb{_id}.
The table is indexed on \verb{_id}.
For a benchmark, see \url{https://github.com/ropensci/nodbi#benchmark}
}
\examples{
\dontrun{
con <- src_sqlite()
print(con)
}

}
