% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reverse_geo_lite_sf.R
\name{reverse_geo_lite_sf}
\alias{reverse_geo_lite_sf}
\title{Get spatial objects through reverse geocoding}
\usage{
reverse_geo_lite_sf(
  lat,
  long,
  address = "address",
  full_results = FALSE,
  return_coords = TRUE,
  verbose = FALSE,
  custom_query = list(),
  points_only = TRUE
)
}
\arguments{
\item{lat}{latitude values (input data)}

\item{long}{longitude values (input data)}

\item{address}{name of the address column (in the output data)}

\item{full_results}{returns all data from the geocoder service if TRUE.
If FALSE then only a single address column will be returned from the geocoder service.}

\item{return_coords}{return input coordinates with results if TRUE. Note that
most services return the input coordinates with \code{full_results = TRUE} and setting
\code{return_coords} to FALSE does not prevent this.}

\item{verbose}{if TRUE then detailed logs are output to the console}

\item{custom_query}{API-specific parameters to be used, passed as a named
list (ie. \code{list(zoom = 3)}). See Details.}

\item{points_only}{Logical \code{TRUE/FALSE}. Whether to return only spatial points (\code{TRUE}, which is the default) or potentially other shapes as provided by the Nominatim API (\code{FALSE}).}
}
\value{
A \code{sf} object with the results.
}
\description{
This function allows you extract the spatial object located on a known pair
of coordinates (lat, long). Latitudes must be between -90 and 90 and
longitudes must be between -180 and 180.
}
\details{
See \url{https://nominatim.org/release-docs/develop/api/Reverse/} for additional
parameters to be passed to \code{custom_query}.

Use the option \code{custom_query = list(zoom = 3)} to adjust the output. Some
equivalences on terms of zoom:\tabular{rl}{
   zoom \tab address_detail \cr
   3 \tab country \cr
   5 \tab state \cr
   8 \tab county \cr
   10 \tab city \cr
   14 \tab suburb \cr
   16 \tab major streets \cr
   17 \tab major and minor streets \cr
   18 \tab building \cr
}
}
\examples{
\dontshow{if (nominatim_check_access()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
library(ggplot2)


Coliseum <- geo_lite("Coliseo, Rome, Italy")

# Coliseum
Col_sf <- reverse_geo_lite_sf(
  lat = Coliseum$lat,
  lon = Coliseum$lon,
  points_only = FALSE
)

ggplot(Col_sf) +
  geom_sf()

# City of Rome - Zoom 10

Rome_sf <- reverse_geo_lite_sf(
  lat = Coliseum$lat,
  lon = Coliseum$lon,
  custom_query = list(zoom = 10),
  points_only = FALSE
)

ggplot(Rome_sf) +
  geom_sf()

# County - Zoom 8

County_sf <- reverse_geo_lite_sf(
  lat = Coliseum$lat,
  lon = Coliseum$lon,
  custom_query = list(zoom = 8),
  points_only = FALSE
)

ggplot(County_sf) +
  geom_sf()
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=reverse_geo_lite]{reverse_geo_lite()}}

Other spatial: 
\code{\link{bbox_to_poly}()},
\code{\link{geo_address_lookup_sf}()},
\code{\link{geo_amenity_sf}()},
\code{\link{geo_lite_sf}()}
}
\concept{spatial}
