% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geo_address_lookup_sf.R
\name{geo_address_lookup_sf}
\alias{geo_address_lookup_sf}
\title{Address Lookup API for OSM objects in Spatial Format}
\usage{
geo_address_lookup_sf(
  osm_ids,
  type = c("N", "W", "R"),
  full_results = FALSE,
  return_addresses = TRUE,
  verbose = FALSE,
  custom_query = list(),
  points_only = TRUE
)
}
\arguments{
\item{osm_ids}{vector of OSM identifiers as \strong{numeric}
(\code{c(00000, 11111, 22222)}).}

\item{type}{vector character of the type of the OSM type associated to each
\code{osm_ids}. Possible values are node (\code{"N"}), way (\code{"W"}) or relation
(\code{"R"}). If a single value is provided it would be recycled.}

\item{full_results}{returns all available data from the API service.
If \code{FALSE} (default) only address columns are returned. See also
\code{return_addresses}.}

\item{return_addresses}{return input addresses with results if \code{TRUE}.}

\item{verbose}{if \code{TRUE} then detailed logs are output to the console.}

\item{custom_query}{A named list with API-specific parameters to be used
(i.e. \code{list(countrycodes = "US")}). See \strong{Details}.}

\item{points_only}{Logical \code{TRUE/FALSE}. Whether to return only spatial
points (\code{TRUE}, which is the default) or potentially other shapes as
provided by the Nominatim API (\code{FALSE}). See \strong{About Geometry Types}.}
}
\value{
A \code{sf} object with the results.
}
\description{
The lookup API allows to query the address and other details of one or
multiple OSM objects like node, way or relation. This function returns the
\pkg{sf} spatial object associated with the query, see
\code{\link[=geo_address_lookup]{geo_address_lookup()}} for retrieving the data in \code{tibble} format.
}
\details{
See \url{https://nominatim.org/release-docs/latest/api/Lookup/} for additional
parameters to be passed to \code{custom_query}.
}
\section{About Geometry Types}{


The parameter \code{points_only} specifies whether the function results will be
points (all Nominatim results are guaranteed to have at least point
geometry) or possibly other spatial objects.

Note that the type of geometry returned in case of \code{points_only = FALSE}
will depend on the object being geocoded:
\itemize{
\item administrative areas, major buildings and the like will be
returned as polygons
\item rivers, roads and their like as lines
\item amenities may be points even in case of a \code{points_only = FALSE} call
}

The function is vectorized, allowing for multiple addresses to be geocoded;
in case of \code{points_only = FALSE}  multiple geometry types may be returned.
}

\examples{
\dontshow{if (nominatim_check_access()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
# Notre Dame Cathedral, Paris

NotreDame <- geo_address_lookup_sf(osm_ids = 201611261, type = "W")

library(ggplot2)

ggplot(NotreDame) +
  geom_sf()

NotreDame_poly <- geo_address_lookup_sf(201611261,
  type = "W",
  points_only = FALSE
)

ggplot(NotreDame_poly) +
  geom_sf()

# It is vectorized

several <- geo_address_lookup_sf(c(146656, 240109189), type = c("R", "N"))
several
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=geo_address_lookup]{geo_address_lookup()}}

Address Lookup API: 
\code{\link{geo_address_lookup}()}

Geocoding strings: 
\code{\link{geo_address_lookup}()},
\code{\link{geo_amenity_sf}()},
\code{\link{geo_amenity}()},
\code{\link{geo_lite_sf}()},
\code{\link{geo_lite}()}

Get spatial (`sf`) objects: 
\code{\link{bbox_to_poly}()},
\code{\link{geo_amenity_sf}()},
\code{\link{geo_lite_sf}()},
\code{\link{reverse_geo_lite_sf}()}
}
\concept{geocoding}
\concept{lookup}
\concept{spatial}
