% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geo_lite_sf.R
\name{geo_lite_sf}
\alias{geo_lite_sf}
\title{Address Search API for OSM objects in Spatial format}
\usage{
geo_lite_sf(
  address,
  limit = 1,
  return_addresses = TRUE,
  full_results = FALSE,
  verbose = FALSE,
  custom_query = list(),
  points_only = TRUE
)
}
\arguments{
\item{address}{character with single line address
(\code{"1600 Pennsylvania Ave NW, Washington"}) or a vector of addresses
(\code{c("Madrid", "Barcelona")}).}

\item{limit}{maximum number of results to return per input address. Note
that each query returns a maximum of 50 results.}

\item{return_addresses}{return input addresses with results if \code{TRUE}.}

\item{full_results}{returns all available data from the API service.
If \code{FALSE} (default) only address columns are returned. See also
\code{return_addresses}.}

\item{verbose}{if \code{TRUE} then detailed logs are output to the console.}

\item{custom_query}{A named list with API-specific parameters to be used
(i.e. \code{list(countrycodes = "US")}). See \strong{Details}.}

\item{points_only}{Logical \code{TRUE/FALSE}. Whether to return only spatial
points (\code{TRUE}, which is the default) or potentially other shapes as
provided by the Nominatim API (\code{FALSE}). See \strong{About Geometry Types}.}
}
\value{
A \code{sf} object with the results.
}
\description{
This function allows you to geocode addresses and return the corresponding
spatial object. This function returns the \pkg{sf} spatial object
associated with the query, see \code{\link[=geo_lite_sf]{geo_lite_sf()}} for retrieving the data in
\code{tibble} format.
}
\details{
See \url{https://nominatim.org/release-docs/latest/api/Search/} for additional
parameters to be passed to \code{custom_query}.
}
\section{About Geometry Types}{


The parameter \code{points_only} specifies whether the function results will be
points (all Nominatim results are guaranteed to have at least point
geometry) or possibly other spatial objects.

Note that the type of geometry returned in case of \code{points_only = FALSE}
will depend on the object being geocoded:
\itemize{
\item administrative areas, major buildings and the like will be
returned as polygons
\item rivers, roads and their like as lines
\item amenities may be points even in case of a \code{points_only = FALSE} call
}

The function is vectorized, allowing for multiple addresses to be geocoded;
in case of \code{points_only = FALSE}  multiple geometry types may be returned.
}

\examples{
\dontshow{if (nominatim_check_access()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
# Map - Points
library(ggplot2)

string <- "Statue of Liberty, NY, USA"
sol <- geo_lite_sf(string)

ggplot(sol) +
  geom_sf()

sol_poly <- geo_lite_sf(string, points_only = FALSE)

ggplot(sol_poly) +
  geom_sf() +
  geom_sf(data = sol, color = "red")


# Several results

Madrid <- geo_lite_sf("Madrid",
  limit = 2,
  points_only = FALSE, full_results = TRUE
)


ggplot(Madrid) +
  geom_sf(fill = NA)

Starbucks <- geo_lite_sf("Starbucks, New York",
  limit = 20, full_results = TRUE
)


ggplot(Starbucks) +
  geom_sf()
}
\dontshow{\}) # examplesIf}
}
\seealso{
Geocoding strings: 
\code{\link{geo_address_lookup_sf}()},
\code{\link{geo_address_lookup}()},
\code{\link{geo_amenity_sf}()},
\code{\link{geo_amenity}()},
\code{\link{geo_lite}()}

Get spatial (`sf`) objects: 
\code{\link{bbox_to_poly}()},
\code{\link{geo_address_lookup_sf}()},
\code{\link{geo_amenity_sf}()},
\code{\link{reverse_geo_lite_sf}()}
}
\concept{geocoding}
\concept{spatial}
