% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/path.R
\name{psn_options}
\alias{psn_options}
\title{Set PsN Options}
\usage{
psn_options(
  project = "NONMEM",
  modex = "mod",
  fields = c("symbol", "unit", "transform", "label"),
  nested = psn_nested,
  ...
)
}
\arguments{
\item{project}{character, path to project directory}

\item{modex}{character, extension for model control stream (no dot)}

\item{fields}{character}

\item{nested}{logical, or function of file extension returning logical}

\item{...}{ignored}
}
\value{
used for side-effects (sets options 'fields' and 'nested')
}
\description{
Sets PsN-style directory and control stream options.
Supports control streams with semicolon-delimited metadata
including symbol, unit, transform, and label.
Expects model files to be found in nested directory,
except for *.mod and *.lst.
}
\examples{
\dontrun{
psn_options()
}
}
\seealso{
Other path: 
\code{\link{datafile.character}()},
\code{\link{datafile.numeric}()},
\code{\link{datafile}()},
\code{\link{modeldir}()},
\code{\link{modelfile}()},
\code{\link{modelpath.character}()},
\code{\link{modelpath.numeric}()},
\code{\link{modelpath}()},
\code{\link{specfile.character}()},
\code{\link{specfile.numeric}()},
\code{\link{specfile}()}
}
\concept{path}
