% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nowcasting.R
\docType{package}
\name{nowcasting}
\alias{nowcasting}
\alias{nowcasting-package}
\title{Nowcast Analysis and Create Real-Time Data Basis}
\description{
This package is an initiative of the Center for Statistical and Computational Methods (NMEC) belonging to the Brazilian Institute of Economics (IBRE) of the Getulio Vargas Foundation (FGV). Our goal is to develop a real-time predictive measure of Brazilian GDP that helps IBRE researchers in their analysis about the Brazilian economy.

The purpose of this package is to disseminate to the community of \code{R} users the statistical tools and techniques of 'nowcast' already known in the academic literature. One can find in this package a simple and practical way to reproduce several of these techniques for their studies.

In this version of the package we present three methods, based on seminal articles in this literature:
\emph{Giannone et al. 2008}, \emph{Bańbura et al. 2011} and \emph{Bańbura and Rünstler 2011}
Some backend functions are adaptations and translations of these paper's \emph{replication files} avaible in MATLAB. One can find these \emph{replication files} in the following url:
\url{https://www.newyorkfed.org/research/economists/giannone/pub}
}
\note{
The authors would like to thank the support by the Getulio 
Vargas Foundation (FGV).
}
\references{
Giannone, D., Reichlin, L., & Small, D. (2008). Nowcasting: The real-time informational content of macroeconomic data. Journal of Monetary Economics, 55(4), 665-676.<doi:10.1016/j.jmoneco.2008.05.010>

Bańbura, M., & Rünstler, G. (2011). A look into the factor model black box: publication lags and the role of hard and soft data in forecasting GDP. International Journal of Forecasting, 27(2), 333-346. <doi:10.1016/j.ijforecast.2010.01.011>

Bańbura M., Giannone, D. & Reichlin, L. (2011). Nowcasting, in Michael P. Clements and David F. Hendry, editors, Oxford Handbook on Economic Forecasting, pages 193-224, January 2011. <doi:10.1093/oxfordhb/9780195398649.001.0001>
}
\author{
Daiane Mattos \email{daiane.mattos@fgv.br},
        Guilherme Branco \email{guilherme.branco@fgv.br},
        Pedro Costa Ferreira \email{pedro.guilherme@fgv.br}
}
