% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ICshocks.R
\name{ICshocks}
\alias{ICshocks}
\title{Information criterion for determining the number of shocks in a factor model}
\usage{
ICshocks(x, delta = 0.1, m = 1, r = NULL, p = NULL)
}
\arguments{
\item{x}{a dataset;}

\item{delta}{a real number within the range (0,1/2) for the sensitivity of the tolerance level to the size of the dataset;}

\item{m}{a finite positive real number defining the tolerance level;}

\item{r}{a positive integer corresponding to the number of factors;}

\item{p}{a positive integer corresponding to the number of lags to be considered within the model.}
}
\value{
A \code{list} containing two elements:

\item{q_star}{The number of shocks minimizing the information criterion;}
\item{p}{The number of lags used.}
}
\description{
The function gives the number of shocks that minimizes the information criterion.
}
\references{
Bai, J., Ng, S. (2007). Determining the Number of Primitive Shocks in Factor Models. Journal of Business & Economic Statistics, 25(1), 52-60. <https://doi.org/10.1198/073500106000000413>
}
