% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oxy-pwr2n.NPH.R
\name{pwr2n.NPH}
\alias{pwr2n.NPH}
\title{Sample Size Calculation with Combination Test}
\usage{
pwr2n.NPH(
  method = "MaxLR",
  entry = 1,
  fup = 1,
  CtrlHaz,
  hazR,
  transP1 = c(0, 0),
  transP0 = c(0, 0),
  Wlist = list(function(x) {     x^0 }),
  entry_pdf0 = function(x) {     (1/entry) * (x >= 0 & x <= entry) },
  entry_pdf1 = entry_pdf0,
  ratio = 1,
  alpha = 0.05,
  beta = 0.1,
  alternative = c("two.sided"),
  criteria = 500,
  k = 100,
  summary = TRUE
)
}
\arguments{
\item{method}{a text specifying the calculation method, either
\code{"MaxLR"} or \code{"Projection"}. Maximum weighted
logrank test is used if \code{"MaxLR"} is specified; otherwise,
projection test is used.}

\item{entry}{a numeric value indicating the enrollment time, Default: 1}

\item{fup}{a numeric value indicating the minimum follow-up time for subjects.
, Default: 1}

\item{CtrlHaz}{a function,  specifying the hazard function for control group.}

\item{hazR}{a function, specifying the hazard ratio function between
treatment and control group}

\item{transP1}{a numeric vector of length 2, consisting of the transition
probability from
receiving treatment to drop-out (drop-out rate) and
from receiving treatment to receiving control (drop-in rate) per time unit.}

\item{transP0}{a numeric vector of length 2, consisting of the transition
probability from
receiving control to drop-out (drop-out rate) and
from receiving control to receiving treatment (drop-in rate) per time unit.}

\item{Wlist}{a list, consisting of weight functions applied to the test.
The element of the list must be functions. Default is a list of one constant
function, corresponding to the logrank test.}

\item{entry_pdf0}{a function, indicating the probability density function (pdf)
of enrollment time for control group. The default assumes a uniform distribution
corresponding to the constant enrollment rate.
Default: function(x) {
(1/entry) * (x >= 0 & x <= entry)
}}

\item{entry_pdf1}{a pdf of enrollment time for treatment
group. See \code{entry_pdf0}, Default: assume same pdf as control group.}

\item{ratio}{an integer, indicating the randomization ratio between treatment
and control group, Default: 1}

\item{alpha}{type I error rate, Default: 0.05}

\item{beta}{type II error rate, Default: 0.1}

\item{alternative}{a character string specifying the alternative hypothesis,
must be one of "\code{two.sided}", "\code{greater}","\code{less}". See details.
For \code{"Projection"} method, only \code{"two-sided"}
alternative is supported. Default: c("\code{two.sided}")}

\item{criteria}{an integer indicating the maximum iteration allowed in
obtaining the number of events. See details , Default: 500}

\item{k}{an integer, indicating number of sub-intervals per time unit,
Default: 100}

\item{summary}{a logical value, controlling whether to print the
summary of calculation, Default: TRUE}
}
\value{
An object of class "\code{NPHpwr}" with corresponding \code{plot} function.
The object is a list containing the following components:
\item{eventN}{total number of events}
\item{totalN}{total number of subjects}
\item{pwr}{actual power given the number of events}
\item{prob_event}{event probability at the end of trial}
\item{L_trans}{a list, consisting of transition matrix at each interval}
\item{pdat}{ a dataframe including all the intermediate variables in the calculation.
see Details.}
\item{studytime}{a vector of length 2, including the entry and follow-up time as input}
\item{RandomizationRatio}{as input}
\item{eventlist}{a vector containing the number of events using each
weight function alone}
\item{inputfun}{a list containing all the input functions specified by
users}
}
\description{
\code{pwr2n.NPH} calculates the number of events and
subjects required to achieve pre-specified power in the setup of two groups.
The method extends the calculation in the framework of the Markov model by Lakatos, allowing
for using the maximum weighted logrank tests or projection test with an arbitrary number of weight
functions. For maximum weighted logrank type test, if only one weight function
is provided, the test is essentially
the classic (weighted) logrank test.
}
\details{
The detailed methods can be found in the reference papers. The number
of subjects is determined by several factors, including the control hazard function,
hazard ratio function, entry time distribution, follow-up time, etc.  Under proportional
hazard assumption, the number of events is mainly determined by the hazard ratio besides
type i/ii error rates. However, under nonproportional hazards, all the above design parameters
may have an impact on the number of events.
The study design assumes \code{entry} time units of
enrollment and at least \code{fup} time units of follow-up. If enrollment
time \code{entry} is set to zero, all subjects are enrolled simultaneously,
so there is no staggered entry. Otherwise, if
\code{entry} is greater than 0, administrative censoring is considered. The user-defined
enrollment time function, hazard function for the control group and hazard ratio function can be either discrete or continuous.
Various non-proportional hazards types are accommodated. See examples below.
If multiple weight functions are provided in \code{Wlist}, a maximum weighted logrank
test or combination test is implemented. An iterative procedure
is used to obtain the event number based on the multivariate normal distribution.  Package
\pkg{mvtnorm} is used to calculate the quantiles. Because the algorithm is slightly
seed dependent, the quantiles are mean values of ten replicates.

The "\code{alternative}" option supports both two-sided and one-sided test.
Let \eqn{\Lambda_1} and \eqn{\Lambda_0} denote the cumulative hazard of
treatment and control group. The \code{less} option tests
\eqn{H_0: \Lambda_1 > \Lambda_0} against
\eqn{H_a: \Lambda_1 <= \Lambda_0}. The \code{greater} option tests
\eqn{H_0: \Lambda_1 < \Lambda_0} against \eqn{H_a: \Lambda_1 >= \Lambda_0}.
}
\examples{
 #------------------------------------------------------------
 ## Delayed treatment effects using maxcombo test
 ## generate a list of weight functions for maxcombot test
 wmax <- gen.wgt(method = "Maxcombo" )
 t_enrl <- 12; t_fup <- 18; lmd0 <- log(2)/12
 ## delayed treatment effects
 f_hr_delay <- function(x){(x<=6)+(x>6)*0.75}
 f_haz0 <- function(x){lmd0*x^0}
 ##  The following code takes more than 5 seconds to run
 \donttest{
 snph1 <- pwr2n.NPH(entry = t_enrl, fup = t_fup, Wlist = wmax,
                    k = 100, ratio = 2, CtrlHaz = f_haz0, hazR = f_hr_delay)
 }
 #-------------------------------------------------------------
 # same setting using projection test
 snph2 <- pwr2n.NPH(method = "Projection", entry = t_enrl,
  fup = t_fup, Wlist = wmax, k = 10, ratio = 2, CtrlHaz = f_haz0,
  hazR = f_hr_delay)

 #-------------------------------------------------------------
 #proportional hazards with weibull survival for control group
 #logrank test
 wlr <- gen.wgt(method = "LR" )
 b0 <- 3
 th0 <- 10/(-log(0.2))^(1/b0)
 #Weibull hazard function
 f_hz_weibull <- function(x){b0/th0^b0*x^(b0-1)}
 #hazard ratio function
 f_hr <- function(x){0.5*x^0}
 # define entry and follow-up time
 t_enrl <- 5; t_fup <- 5
 exph1 <- pwr2n.NPH(entry = t_enrl, fup = t_fup, k = 100,
 Wlist = wlr,  CtrlHaz = f_hz_weibull, hazR = f_hr, summary = FALSE)
 summary(exph1)
}
\references{
Brendel, M., Janssen, A., Mayer, C. D., & Pauly, M. (2014). Weighted logrank
permutation tests for randomly right censored life science data. Scandinavian
Journal of Statistics, 41(3), 742-761.

Cheng, H., & He, J. (2021). A Maximum Weighted Logrank Test in Detecting
Crossing Hazards. arXiv preprint arXiv:2110.03833.

Cheng, H., & He, J. (2021). Sample size calculation for the maximum weighted
logrank test under non-proportional hazards (to submit)
}
\seealso{
\code{\link{pwr2n.LR}}
\code{\link{gen.wgt}}, \code{\link{evalfup}}
}
