% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.frfast.R
\name{predict.frfast}
\alias{predict.frfast}
\title{Prediction from fitted \code{frfast} model}
\usage{
\method{predict}{frfast}(object = model, newdata, fac = NULL, der = NULL,
  seed = NULL, ...)
}
\arguments{
\item{object}{A fitted \code{frfast} object as produced by \code{frfast()}.}

\item{newdata}{A data frame containing the values of the model covariates
at which predictions are required.  If newdata is provided, then it should 
contain all the variables needed for prediction: a warning is 
generated if not.}

\item{fac}{Factor's level to take into account. By default is \code{NULL}.}

\item{der}{Number which determines any inference process. By default 
\code{der} is \code{NULL}. If this term is \code{0}, 
the function returns the initial estimate. If it is \code{1} or \code{2}, 
it is designed for the first or second derivative, respectively.}

\item{seed}{Seed to be used in the bootstrap procedure.}

\item{\ldots}{Other options.}
}
\value{
\code{predict.frfast} computes and returns a list containing 
predictions of the estimates, first and second derivative, 
with their 95\% confidence intervals.
}
\description{
Takes a fitted \code{frfast} object  and produces predictions 
(with their 95\% confidence intervals) from a fitted model with 
interactions or without interactions.
}
\examples{
library(npregfast)
data(barnacle)

# Nonparametric regression without interactions
fit <- frfast(DW ~ RC, data = barnacle, nboot = 100)
nd <- data.frame(RC = c(10, 14, 18))
predict(fit, newdata = nd)

# Nonparametric regression with interactions
# fit2 <- frfast(DW ~ RC : F, data = barnacle, nboot = 100)
# nd2 <- data.frame(RC = c(10, 15, 20))
# predict(fit2, newdata = nd2)
# predict(fit2, newdata = nd2, der = 0, fac = "barca")
 
}
\author{
Marta Sestelo, Nora M. Villanueva and Javier Roca-Pardinas.
}

