% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spersp.R
\name{spersp}
\alias{spersp}
\alias{spersp.default}
\alias{spersp.data.grid}
\title{Perspective plot with a color scale}
\usage{
spersp(x, ...)

\method{spersp}{default}(x = seq(0, 1, len = nrow(z)), y = seq(0, 1,
  len = ncol(z)), z, s = z, slim = range(s, finite = TRUE),
  col = jet.colors(128), breaks = NULL, legend = TRUE,
  horizontal = FALSE, legend.shrink = 0.8, legend.width = 1.2,
  legend.mar = ifelse(horizontal, 3.1, 5.1), legend.lab = NULL,
  bigplot = NULL, smallplot = NULL, lab.breaks = NULL,
  axis.args = NULL, legend.args = NULL, graphics.reset = FALSE,
  xlab = NULL, ylab = NULL, zlab = NULL, theta = 40, phi = 20,
  ticktype = "detailed", cex.axis = 0.75, ...)

\method{spersp}{data.grid}(x, data.ind = 1, s = x[[data.ind]],
  xlab = NULL, ylab = NULL, zlab = NULL, ...)
}
\arguments{
\item{x}{grid values for \code{x} coordinate. If \code{x} is a list, 
its components \code{x$x} and \code{x$y} are used for \code{x}  
and \code{y}, respectively. If the list has component \code{z} this is used 
for \code{z}.}

\item{...}{additional graphical parameters (to be passed to \code{\link{persp}} 
or \code{spersp.default}; e.g. \code{xlim, ylim, zlim,} ...). NOTE:
graphical arguments passed here will only have impact on the main plot. 
To change the graphical defaults for the legend use the \code{\link{par}} 
function beforehand (e.g. \code{par(cex.lab = 2)} to increase colorbar labels).}

\item{y}{grid values for \code{y} coordinate.}

\item{z}{matrix containing the values to be plotted (NAs are allowed).
Note that \code{x} can be used instead of \code{z} for convenience.}

\item{s}{matrix containing the values used for coloring the facets.}

\item{slim}{limits used to set up the color scale.}

\item{col}{color table used to set up the color scale (see \code{\link{image}} for
details).}

\item{breaks}{(optional) numeric vector with the breakpoints for the color scale: 
must have one more breakpoint than \code{col} and be in increasing order.}

\item{legend}{logical; if \code{TRUE} (default), the plotting region is splitted into two parts,
drawing the perspective plot in one and the legend with the color scale in the other.
If \code{FALSE} only the (coloured) perspective plot is drawn and the arguments related 
to the legend are ignored (\code{\link{splot}} is not called).}

\item{horizontal}{logical; if \code{FALSE} (default) legend will be a vertical strip on the
right side. If \code{TRUE} the legend strip will be along the bottom.}

\item{legend.shrink}{amount to shrink the size of legend relative to the
full height or width of the plot.}

\item{legend.width}{width in characters of the legend strip. Default is
1.2, a little bigger that the width of a character.}

\item{legend.mar}{width in characters of legend margin that has the axis.
Default is 5.1 for a vertical legend and 3.1 for a horizontal legend.}

\item{legend.lab}{label for the axis of the color legend. Default is no
label as this is usual evident from the plot title.}

\item{bigplot}{plot coordinates for main plot. If not passed these will be 
determined within the function.}

\item{smallplot}{plot coordinates for legend strip. If not passed these
will be determined within the function.}

\item{lab.breaks}{if breaks are supplied these are text string labels to
put at each break value. This is intended to label axis on a transformed
scale such as logs.}

\item{axis.args}{additional arguments for the axis function used to create
the legend axis (see \code{\link[fields]{image.plot}} for details).}

\item{legend.args}{arguments for a complete specification of the legend
label. This is in the form of list and is just passed to the \code{\link{mtext}}
function. Usually this will not be needed (see \code{\link[fields]{image.plot}} 
for details).}

\item{graphics.reset}{logical; if \code{FALSE} (default) the plotting region
(\code{\link{par}("plt")}) will not be reset to make it possible to add more features
to the plot (e.g. using functions such as points or lines). If \code{TRUE} will
reset plot parameters to the values before entering the function.}

\item{xlab}{label for the x axis, defaults to a description of \code{x}.}

\item{ylab}{label for the y axis, defaults to a description of \code{y}.}

\item{zlab}{label for the z axis, defaults to a description of \code{z}.}

\item{theta}{x-y rotation angle for perspective (azimuthal direction).}

\item{phi}{z-angle for perspective (colatitude).}

\item{ticktype}{character; \code{"simple"} draws just an arrow parallel to the axis 
to indicate direction of increase; \code{"detailed"} draws normal ticks as per 2D plots.}

\item{cex.axis}{magnification to be used for axis annotation (relative to the 
current setting of \code{\link{par}("cex")}).}

\item{data.ind}{integer (or character) with the index (or name) of the component 
containing the \code{z} values to be plotted.}
}
\value{
Invisibly returns a list with the following 4 components:
\item{pm}{the viewing transformation matrix (see \code{\link{persp}} for details), 
a 4 x 4 matrix that can be used to superimpose additional graphical elements 
using the function \code{\link{trans3d}}.} 
\item{bigplot}{plot coordinates of the main plot. These values may be useful for 
drawing a plot without the legend that is the same size as the plots with legends.}
\item{smallplot}{plot coordinates of the secondary plot (legend strip).}
\item{old.par}{previous graphical parameters (\code{par(old.par)} 
will reset plot parameters to the values before entering the function).}
}
\description{
\code{spersp} (generic function) draws a perspective plot of a surface over 
the \code{x-y} plane with the facets being filled with different colors 
and (optionally) adds a legend strip with the color scale 
(calls \code{\link{splot}} and \code{\link{persp}}).
}
\section{Side Effects}{
 After exiting, the plotting region may be changed 
(\code{\link{par}("plt")}) to make it possible to add more features to the plot
(set \code{graphics.reset = FALSE} to avoid this).
}

\examples{

#
# Regularly spaced 2D data
nx <- c(40, 40) # ndata =  prod(nx)
x1 <- seq(-1, 1, length.out = nx[1])
x2 <- seq(-1, 1, length.out = nx[2])
trend <- outer(x1, x2, function(x,y) x^2 - y^2) 
spersp( x1, x2, trend, main = 'Trend', zlab = 'y')

#
# Multiple plots 
set.seed(1)
y <- trend + rnorm(prod(nx), 0, 0.1)
x <- as.matrix(expand.grid(x1 = x1, x2 = x2)) # two-dimensional grid
# local polynomial kernel regression
lp <- locpol(x, y, nbin = nx, h =  diag(c(0.3, 0.3)))
# 1x2 plot
old.par <- par(mfrow = c(1,2))
spersp( x1, x2, y, main = 'Data')
spersp(lp, main = 'Estimated trend', zlab = 'y')
par(old.par)
}
\seealso{
\code{\link{splot}}, \code{\link{spoints}}, \code{\link{simage}}, 
\code{\link{image}}, \code{\link[fields]{image.plot}}, \code{\link{data.grid}}, 
\code{\link{persp}}.
}
\author{
Based on \code{\link[fields]{image.plot}} function from package \pkg{fields}:
fields, Tools for spatial data. 
Copyright 2004-2013, Institute for Mathematics Applied Geosciences. 
University Corporation for Atmospheric Research.

Modified by Ruben Fernandez-Casal <rubenfcasal@gmail.com>.
}
\keyword{hplot}
