% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arg.R
\name{arg}
\alias{arg}
\alias{arg_}
\alias{arg_list}
\alias{arg_list_}
\alias{set_arg}
\alias{set_arg_}
\title{Capture lazy variables as quotations.}
\usage{
arg(sym, env = arg_env_(quote(sym), environment()))

arg_(sym, env = arg_env(sym, environment()))

arg_list(...)

arg_list_(syms, envs)

set_arg(dst, src)

set_arg_(dst, src)
}
\arguments{
\item{sym}{The name to look up. For \code{arg} this is a literal name,
not evaluated. For \code{arg_} this should evaluate to a symbol or
character.}

\item{env}{The environment to look in. By default, the environment
from which \code{sym} was passed.}

\item{...}{Bare names (not forced). Arguments may be named; these
names determine the names on the output list. If arguments are
not named, the names given are used.}

\item{syms}{A character vector or list of names.}

\item{envs}{An environment, or a list of environments, to look for
the bindings in.}

\item{dst}{A name; for \code{set_arg} this is quoted literally; for
\code{set_arg_} this should be a \link{quotation}.}

\item{src}{A \link{quotation} (or something that can be converted to a
quotation, like a formula).}
}
\value{
\code{arg} returns a \link{quotation} object.

\code{args} returns a \link{dots} object.

\code{arg_list} returns a \link{dots} object.
}
\description{
\code{arg(x)} looks in the calling environment for the binding \code{x},
taken literally, and returns it as a \link{quotation}. \code{arg(x)} is
equivalent to \code{unwrap(quo(x))}.

\code{arg_} evaluates the first element normally;
\code{arg(x, e)} is equivalent to \code{arg_(quote(x), e)}.

\code{arg_list} looks up multiple variables, and returns a \link{dots}
object.  \code{arg_list(x, y)} is equivalent to \code{unwrap(dots(x=x, y=y))}. If any of the requested variables are not bound, an error
will be raised.

\code{arg_list_} is a normally evaluating version of \code{arg_list};
\code{arg_list(x, y)} is equivalent to
\code{arg_list_(alist(x, y), environment())}.

\code{set_arg} and set_arg_ create bindings from quotations. They
replace base function \link{delayedAssign}.
}
\note{
If you use a a literal character value, as in \code{arg_("x", environment())}, you MUST also give the environment
parameter. The reason is that R will discard scope information
about code literals in byte-compiled code; so when \code{arg_("x")} is
called in compiled code, the default value for \code{env} will be
found to be \code{\link[=emptyenv]{emptyenv()}}.

Beware of writing \code{arg_list(a, b, ...)} which probably
doesn't do what you want. This is because R unwraps \code{...} before
invoking \code{arg_list}, so this ends up double-unwrapping \code{...}. To
capture \code{...} alongside named arguments you can use the syntax
\code{arg_list(x, y, (...))} (which is equivalent to \code{c(arg_list(x, y), dots(...))}). You can also use \code{\link[=get_call]{get_call()}} to extract all
function inputs to an active function.
}
\seealso{
dots get_dots unwrap
}
