% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getpromise.R
\name{unwrap}
\alias{unwrap}
\alias{unwrap.dots}
\title{Unwrap variable references.}
\usage{
unwrap(x, recursive = FALSE)

\method{unwrap}{dots}(x, recursive = FALSE)
}
\arguments{
\item{x}{a \link{quotation} to unwrap.}

\item{recursive}{Default \code{FALSE} unwraps exactly once. If
\code{TRUE}, unwrap as far as possible (until a forced promise or
nontrivial expression is found.)}
}
\value{
The \link{quotation} method returns a \link{quotation}.

The \link{dots} method returns a dots object with each quotation unwrapped.
}
\description{
Given an un\link{forced} \link{quotation} whose expression is a bare variable
name, \code{unwrap} follows the variable reference, and returns a
quotation. When the argument is forced or has a nontrivial
expression \code{unwrap} has no effect.
}
\details{
There are two good use cases for \code{unwrap(x, recursive=TRUE)}. One
is to derive plot labels (the most inoccuous use of
metaprogramming). Another is to check for missingness (this is what
R's \link{missing} and does as well).

Using \code{unwrap(x, recursive=TRUE)} in other situations can get you
into confusing situations -- effectively you are changing the
behavior of a parent function that may be an unknown number of
levels up the stack, possibly turning a standard-evaluating
function into nonstandard-evaluating function. So recursive
unerapping is not the default behavior.
}
\examples{
# different levels of unwrapping:
f <- function(x) { g(x) }
g <- function(y) { h(y) }
h <- function(z) {
  print(arg(z))
  print(unwrap(quo(z)))
  print(unwrap(unwrap(quo(z))))
  print(unwrap(quo(z), recursive=TRUE))
}

w <- 5
f(w)
}
