% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getpromise.R
\name{locate}
\alias{locate}
\alias{locate_}
\alias{locate_.list}
\alias{locate_.quotation}
\alias{locate_.character}
\alias{locate_.(}
\alias{locate_.dots}
\alias{locate_.name}
\title{Find the environment which defines a name.}
\usage{
locate(sym, env = arg_env_(quote(sym), environment()), mode = "any", ...)

locate_(sym, env = arg_env_(quote(sym), environment()), mode = "any", ...)

locate_.list(sym, env = arg_env_(quote(sym), environment()), mode = "any",
  ...)

locate_.quotation(sym, env = "ignored", mode = "any", ...)

locate_.character(sym, env = arg_env_(quote(sym), environment()),
  mode = "any", ...)

"locate_.("(sym, env = arg_env_(quote(sym), environment()), mode = "any",
  ...)

locate_.dots(sym, env = "ignored", mode = "any", ...)

locate_.name(sym, env = arg_env_(quote(sym), environment()), mode = "any",
  ifnotfound = stop("Binding ", deparse(sym), " not found"))
}
\arguments{
\item{sym}{A name. For \code{locate} the argument is used literally. For
\code{locate_} it should be a \link{name} or list of names.}

\item{env}{Which environment to begin searching from.}

\item{mode}{Either \code{"any"} or \code{"function"}. \code{"any"} finds the
lowest enclosing environment which gives any definiton for \code{sym}.
\code{"function"} searches for an environment which defines \code{sym} as a
function. This may force lazy arguments in the process, in the
same way as \link{get}.}

\item{...}{Further arguments passed to methods.}

\item{ifnotfound}{What is returned if the symbol is not found. By
default an exception is raised.}
}
\value{
An environment object which defines \code{sym}, if one is found.
}
\description{
\code{locate} starts at a given environment, and searches enclosing
environments for a name. It returns the first which defines \code{sym}.

\code{locate_} is the normally evaluating method; \code{locate(x)} is
equivalent to \code{locate_(quo(x))} or \code{locate_(quote(x), environment())}.

If \code{sym} is a list (of \link{name}s) or a \link{dots} object, \code{locate_(sym)}
returns a list.

When \code{sym} is a \link{quotation} or \link{dots}, any \code{env} argument is ignored.
}
\note{
If you use a literal character argument, as in \code{locate("x", environment())}, you must also provide the environment argument
explicitly; \code{locate("x")} won't work in compiled
functions. However using a literal name like \code{locate(x)} will
work OK. See note under \link{arg}.
}
\examples{
# Here is how to implement R's `<<-` operator, using `locate_`:
`\%<<-\%` <- function(lval, rval) {
 lval_ <- arg(lval)
 rval_ <- arg(rval)
 target.env <- locate_(expr(lval_), parent.env(env(lval_)))
 #note that `<-` is a primitive which requires its lvalue and call
 #head to come from teh same env
 env(lval_) <- target.env
 do_(quo(`<-`, target.env), lval_, rval_)
}

x <- "not this one"
local({
  x <- "this one"
  local({
    x <- "not this one either"
    x \%<<-\% "this works like builtin <<-"
  })
  print(x)
})
}
