% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shortcut.R
\name{arg_env}
\alias{arg_env}
\alias{arg_env_}
\alias{arg_expr}
\alias{arg_expr_}
\alias{dots_envs}
\alias{dots_exprs}
\alias{is_forced}
\alias{is_forced_}
\alias{is_literal}
\alias{is_literal_}
\alias{is_missing}
\alias{is_missing_}
\alias{is_promise}
\alias{is_promise_}
\alias{is_default}
\alias{is_default_}
\title{Get information about currently bound arguments.}
\usage{
arg_env(sym, env = arg_env_(quote(sym), environment()))

arg_env_(sym, env = arg_env_(quote(sym), environment()))

arg_expr(sym, env = arg_env_(quote(sym), environment()))

arg_expr_(sym, env = arg_env_(quote(sym), environment()))

dots_envs(...)

dots_exprs(...)

is_forced(...)

is_forced_(syms, envs)

is_literal(...)

is_literal_(syms, envs)

is_missing(...)

is_missing_(syms, envs, recursive = TRUE)

is_promise(...)

is_promise_(syms, envs)

is_default(...)

is_default_(syms, envs = arg_env(syms))
}
\arguments{
\item{sym}{For \code{arg_env}, etc, a bare name (not forced). For the
normally evaluating \code{arg_env_} and so on, \link{name}.}

\item{env}{The environment to search in.}

\item{...}{Bare variable names (for \code{is_*_}) or expressions (for
\code{dots_*}). Not forced.}

\item{syms}{A character vector or list of symbols.}

\item{envs}{An environment or list of environments.}

\item{recursive}{Whether to recursively \link{unwrap} before testing for
missingness.}
}
\value{
\code{arg_expr} extracts an expression from a named argument.

\code{dots_exprs(...)} is equivalent to \code{exprs(dots(...))} (which
is nearly equivalent to \code{alist(...)}.)

\code{is_literal(x)} returns TRUE if \code{x} could be a source
literal. Specifically this tests whether it is X is bound to a
singleton vector or a \link{missing_value}.

\code{is_missing(...)} checks whether a variable is missing,
without forcing. It is similar to \link{missing} but can take
multiple arguments.

\code{is_promise} returns TRUE if the given variable is bound to
a promise. Not all arguments are bound to promises; byte-compiled
code often omits creating a promise for literal arguments

\code{is_default} returns a logical vector.
}
\description{
These are shortcut methods for querying current bindings.  For
example, \code{arg_env(x)} is equivalent to \code{env(arg(x))},
\code{is_forced(x, y)} is equivalent to \code{forced(arg_list(x,y))},
\code{dots_exprs(...)} is equivalent to \code{exprs(dots(...))}, and so
on. The shortcut forms skip the construction of the
intermediate \link{quotation} objects.

\code{is_default}  determines whether an argument is bound to the
function's default value for that argument. It must be called
before the arguments have been forced (afterwards it will return
FALSE).
}
