% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/caller.R
\name{set_}
\alias{set_}
\alias{set_enclos_}
\title{Assign values to variables.}
\usage{
set_(dest, val)

set_enclos_(dest, val)
}
\arguments{
\item{dest}{A \link{quotation} specifying the destination environment
and name. This can also be an indexing, expression, and \code{set_} will
perform subassignment.}

\item{val}{The value to assign.}
}
\value{
\code{set_} returns \code{val}, invisibly.
}
\description{
\code{set_} is a normally-evaluating version of \code{\link{<-}}.
\code{set_enclos_} is a normally evaluating version of
\code{\link{<<-}}.
}
\details{
\code{set_} differs from \verb{[assign]} in that \code{set_} will process
subassignments.

These helpers are here because it is tricky to use \code{\link{do_}} with
\code{\link{<-}} (see Note under \link{do_}).
}
\examples{
set_(quo(x), 12) #equivalent to `x <- 12`
set_(quo(x[3]), 12) #equivalent to `x[3] <- 12`
e <- new.env()
set_(quo(x[3], e), 12) #assigns in environment `e`
set_enclos_(quo(x[3], e), 12) #assigns in a parent of environment `e`
}
