% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{lga_nsw}
\alias{lga_nsw}
\alias{poa_nsw}
\title{Geospatial data of the New South Wales administrative boundaries.}
\format{
An object of class \code{sf} (inherits from \code{tbl_df}, \code{tbl}, \code{data.frame}) with 131 rows and 9 columns.

An object of class \code{sf} (inherits from \code{tbl_df}, \code{tbl}, \code{data.frame}) with 644 rows and 7 columns.
}
\source{
Australian Bureau of Statistics. "Australian Statistical Geography Standard (ASGS) Edition 3." ABS, Jul2021-Jun2026,
\url{https://www.abs.gov.au/statistics/standards/australian-statistical-geography-standard-asgs-edition-3/jul2021-jun2026}, accessed 27 September 2022.

The original dataset is published under the \href{https://creativecommons.org/licenses/by/4.0/}{Creative Commons Attribution 4.0 International} licence, © Commonwealth of Australia 2021.
}
\usage{
lga_nsw

poa_nsw
}
\description{
These include the Unincorporated Far West Region.
\code{lga_nsw} excludes Jervis Bay Territory and the ACT.
\code{poa_nsw} includes both territories and some postal areas extend past the
state boundary.
}
\details{
The geometries have been simplified with a tolerance of 750 m to reduce the
level of detail.
}
\section{Functions}{
\itemize{
\item \code{lga_nsw}: Local Government Area boundaries of New South Wales.

\item \code{poa_nsw}: \href{https://www.abs.gov.au/ausstats/abs@.nsf/Lookup/by\%20Subject/1270.0.55.003~July\%202016~Main\%20Features~Postal\%20Areas\%20(POA)~8}{Postal area} boundaries of New South Wales.

}}
\examples{
library(ggplot2)
ggplot(lga_nsw) + geom_sf(aes(fill = LGA_NAME_2023), show.legend = FALSE)

library(sf)
sf_use_s2(FALSE)
# cut out part of the postcode dataset (it's quite large)
bbox <- st_bbox(c(xmin = 142, xmax = 147, ymin = -33, ymax = -30)) |>
 st_as_sfc(crs = crs_gda2020())
st_crop(poa_nsw, bbox) |>
  ggplot() +
  geom_sf() +
  geom_sf_text(aes(label = POA_CODE_2021), size = 4)
}
\keyword{datasets}
