% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grou.R
\name{grou_mle}
\alias{grou_mle}
\title{Computes the GrOUs MLE of a batch of data}
\usage{
grou_mle(
  times,
  data,
  adj = NA,
  thresholds = NA,
  div = 1000,
  mode = "node",
  output = "vector"
)
}
\arguments{
\item{times}{Times at which data is given}

\item{data}{Values to compute the MLE with.}

\item{adj}{Adjacency matrix of the underlying network.}

\item{thresholds}{Jump threshold values.}

\item{div}{Batch size/divisor to avoid large memory allocation.}

\item{mode}{GrOU mode: either "node" (psi-GrOU) or "network" (theta-GrOU).}

\item{output}{Output type: either "vector"or "matrix".}
}
\value{
The GrOU MLE in matrix/vector form in theta or psi parametrisation.
}
\description{
Computes the GrOUs MLE of a batch of data
}
\examples{
n <- 1000
d <- 10
times <- seq(n)
delta_time <- 0.01
noise <- matrix(rnorm(n * d, sd = sqrt(delta_time)), ncol = d)
data <- construct_path(
  diag(d),
  noise = noise, y_init = rep(0, d), delta_time = delta_time
)
grou_mle(times, data, adj = diag(d), div = 1e2)
}
