% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjacency.R
\name{polymer_network}
\alias{polymer_network}
\title{Creates adjacency matrix with min degree one and max degree two.}
\usage{
polymer_network(d, theta_1, theta_2, directed = FALSE)
}
\arguments{
\item{d}{Number of nodes.}

\item{theta_1}{Off-diagonal value or network effect.}

\item{theta_2}{Diagonal value or momentum effect.}

\item{directed}{Boolean if lower triangular is the opposite
to the upper triangular matrix.}
}
\value{
Adjacency matrix of a graph with max degree two and minimum one.
}
\description{
Creates adjacency matrix with min degree one and max degree two.
}
\examples{
d <- 10
theta_2 <- 2
theta_1 <- 1
polymer_network(d = d, theta_1 = theta_1, theta_2 = theta_2)
}
