% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dig.R
\name{dig}
\alias{dig}
\alias{dig.default}
\alias{dig.matrix}
\alias{dig.data.frame}
\title{Search for rules}
\usage{
dig(x, f, ...)

\method{dig}{default}(x, f, ...)

\method{dig}{matrix}(
  x,
  f,
  condition = everything(),
  focus = NULL,
  disjoint = NULL,
  min_length = 0,
  max_length = Inf,
  min_support = 0,
  t_norm = "goguen",
  ...
)

\method{dig}{data.frame}(
  x,
  f,
  condition = everything(),
  focus = NULL,
  disjoint = NULL,
  min_length = 0,
  max_length = Inf,
  min_support = 0,
  t_norm = "goguen",
  ...
)
}
\arguments{
\item{x}{a matrix or data frame. The matrix must be numeric (double) or logical.
If \code{x} is a data frame then each column must be either numeric (double) or
logical.}

\item{f}{the callback function executed for each generated condition. This
function may have some of the following arguments. Based on the present
arguments, the algorithm would provide information about the generated
condition:
- condition - a numeric vector of column indices that represent the predicates
of the condition. Names of the vector correspond to column names;
- foci_supports - a list of support of foci columns (see \code{focus} argument
to specify, which columns are foci);
- support - a numeric scalar value of the current condition's support;
- indices - a logical vector indicating the rows satisfying the condition;
- weights - (similar to indices) weights of rows to which they satisfy
the current condition.}

\item{...}{Further arguments, currently unused.}

\item{condition}{a tidyselect expression (see
\href{https://tidyselect.r-lib.org/articles/syntax.html}{tidyselect syntax})
specifying the columns to use as condition predicates}

\item{focus}{a tidyselect expression (see
\href{https://tidyselect.r-lib.org/articles/syntax.html}{tidyselect syntax})
specifying the columns to use as focus predicates}

\item{disjoint}{an atomic vector of size equal to the number of columns of \code{x}
that specifies the groups of predicates: if some elements of the \code{disjoint}
vector are equal, then the corresponding columns of \code{x} will NOT be
present together in a single condition.}

\item{min_length}{the minimum size (the minimum number of predicates) of the
condition to be generated (must be greater or equal to 0). If 0, the empty
condition is generated in the first place.}

\item{max_length}{The maximum size (the maximum number of predicates) of the
condition to be generated. If equal to Inf, the maximum length of conditions
is limited only by the number of available predicates.}

\item{min_support}{the minimum support of a condition to trigger the callback
function for it. The support of the condition is the relative frequency
of the condition in the dataset \code{x}. For logical data, it equals to the
relative frequency of rows such that all condition predicates are TRUE on it.
For numerical (double) input, the support is computed as the mean (over all
rows) of multiplications of predicate values.}

\item{t_norm}{a t-norm used to compute conjunction of weights. It must be one of
\code{"goedel"} (minimum t-norm), \code{"goguen"} (product t-norm), or \code{"lukas"}
(Lukasiewicz t-norm).}
}
\value{
A list of results provided by the callback function \code{f}.
}
\description{
This is a general function that enumerates all conditions created from
data in \code{x} and calls the callback function \code{f} on each.
}
\author{
Michal Burda
}
