% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dig_grid.R
\name{dig_grid}
\alias{dig_grid}
\title{Search for grid-based rules}
\usage{
dig_grid(
  x,
  f,
  condition = where(is.logical),
  xvars = where(is.numeric),
  yvars = where(is.numeric),
  na_rm = FALSE,
  type = "bool",
  min_length = 0L,
  max_length = Inf,
  min_support = 0,
  threads = 1,
  ...
)
}
\arguments{
\item{x}{a matrix or data frame with data to search in.}

\item{f}{the callback function to be executed for each generated condition.
The arguments of the callback function differ based on the value of the
\code{type} argument (see below). If \code{type = "bool"}, the callback function
\code{f} must accept a single argument \code{d} of type \code{data.frame} with two
columns (xvar and yvar). It is a subset of the original data frame
with all rows that satisfy the generated condition. If \code{type = "fuzzy"},
the callback function \code{f} must accept an argument \code{d} of type
\code{data.frame} with two columns (xvar and yvar) and a numeric \code{weights}
argument with the same length as the number of rows in \code{d}. The
\code{weights} argument contains the truth degree of the generated condition
for each row of \code{d}. The truth degree is a number in the interval
\eqn{[0, 1]} that represents the degree of satisfaction of the condition
for the row.
In all cases, the function must return a list of scalar values, which
will be converted into a single row of result of final tibble.}

\item{condition}{a tidyselect expression (see
\href{https://tidyselect.r-lib.org/articles/syntax.html}{tidyselect syntax})
specifying the columns to use as condition predicates. The selected
columns must be logical or numeric. If numeric, fuzzy conditions are
considered.}

\item{xvars}{a tidyselect expression (see
\href{https://tidyselect.r-lib.org/articles/syntax.html}{tidyselect syntax})
specifying the columns of \code{x}, whose names will be used as a domain for
combinations use at the first place (xvar)}

\item{yvars}{a tidyselect expression (see
\href{https://tidyselect.r-lib.org/articles/syntax.html}{tidyselect syntax})
specifying the columns of \code{x}, whose names will be used as a domain for
combinations use at the second place (yvar)}

\item{na_rm}{a logical value indicating whether to remove rows with missing
values from sub-data before the callback function \code{f} is called}

\item{type}{a character string specifying the type of conditions to be processed.
The \code{"bool"} type accepts only logical columns as condition predicates.
The \code{"fuzzy"} type accepts both logical and numeric columns as condition
predicates where numeric data are in the interval \eqn{[0, 1]}. The
callback function \code{f} differs based on the value of the \code{type} argument
(see the description of \code{f} above).}

\item{min_length}{the minimum size (the minimum number of predicates) of the
condition to be generated (must be greater or equal to 0). If 0, the empty
condition is generated in the first place.}

\item{max_length}{the maximum size (the maximum number of predicates) of the
condition to be generated. If equal to Inf, the maximum length of conditions
is limited only by the number of available predicates.}

\item{min_support}{the minimum support of a condition to trigger the callback
function for it. The support of the condition is the relative frequency
of the condition in the dataset \code{x}. For logical data, it equals to the
relative frequency of rows such that all condition predicates are TRUE on it.
For numerical (double) input, the support is computed as the mean (over all
rows) of multiplications of predicate values.}

\item{threads}{the number of threads to use for parallel computation.}

\item{...}{Further arguments, currently unused.}
}
\value{
A tibble with found rules. Each row represents a single call of
the callback function \code{f}.
}
\description{
This function creates a grid of combinations of pairs of columns specified
by \code{xvars} and \code{yvars} (see also \code{\link[=var_grid]{var_grid()}}). After that, it enumerates all
conditions created from data in \code{x} (by calling \code{\link[=dig]{dig()}}) and for each such
condition and for each row of the grid of combinations, a user-defined
function \code{f} is executed on each sub-data created from \code{x} by selecting all
rows of \code{x} that satisfy the generated condition and by selecting the
columns in the grid's row.
}
\seealso{
\code{\link[=dig]{dig()}}, \code{\link[=var_grid]{var_grid()}}, and \code{\link[=dig_correlations]{dig_correlations()}}, as it is using this
function internally
}
\author{
Michal Burda
}
