% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_weekday.R
\name{f_weekday}
\alias{f_weekday}
\alias{f_weekday.default}
\alias{f_weekday.numeric}
\alias{f_weekday.Date}
\alias{f_weekday.POSIXt}
\alias{f_weekday.hms}
\alias{ff_weekday}
\title{Format Weekdays to One Letter Abbreviation}
\usage{
f_weekday(x, distinct = FALSE, ...)

\method{f_weekday}{default}(x, distinct = FALSE, ...)

\method{f_weekday}{numeric}(x, distinct = FALSE, ...)

\method{f_weekday}{Date}(x, distinct = FALSE, ...)

\method{f_weekday}{POSIXt}(x, distinct = FALSE, ...)

\method{f_weekday}{hms}(x, distinct = FALSE, ...)

ff_weekday(distinct = FALSE, ...)
}
\arguments{
\item{x}{A vector of weekday names, integers 1-12, or dates.}

\item{distinct}{logical.  If \code{TRUE} Sunday will be presented as \code{Su}
and Thursday as \code{Th}.}

\item{\ldots}{ignored.}
}
\value{
Returns a single letter month abbreviation atomic vector.
}
\description{
Format long weekday name, integer, or date formats to a single capital letter.
Useful for plot scales as a way to save space.
}
\examples{
f_weekday(weekdays(x=as.Date(seq(7), origin="1950-01-07")))
f_weekday(weekdays(x=as.Date(seq(7), origin="1950-01-07")), TRUE)

f_weekday(1:7)
f_weekday(1:7, TRUE)

days <- seq(as.Date("2000/1/2"), by = "day", length.out = 7)
f_weekday(days)
f_weekday(days, TRUE)

\dontrun{
if (!require("pacman")) install.packages("pacman")
pacman::p_load(tidyverse)

set.seed(10)
dat <- data_frame(
    day = sample(weekdays(days), 10000, TRUE),
    area =  sample(LETTERS[1:15], 10000, TRUE)
) \%>\%
    count(day, area) \%>\%
    ungroup() \%>\%
    mutate(
        day = factor(day, levels = weekdays(days))
    )

## without date formatting
ggplot(dat, aes(day, n)) +
    geom_bar(stat = 'identity') +
    facet_wrap(~area)

## with date formatting
ggplot(dat, aes(day, n)) +
    geom_bar(stat = 'identity') +
    facet_wrap(~area) +
    scale_x_discrete(labels = f_weekday)

## with date formatting
ggplot(dat, aes(day, n)) +
    geom_bar(stat = 'identity') +
    facet_wrap(~area) +
    scale_x_discrete(labels = ff_weekday(distinct = TRUE))
}
}
