% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getTranscriptAttributes.R
\name{getTranscriptAttributes}
\alias{getTranscriptAttributes}
\title{Gets transcript attribute values for given transcript IDs}
\usage{
getTranscriptAttributes(labbcat.url, transcript.ids, layer.ids)
}
\arguments{
\item{labbcat.url}{URL to the LaBB-CAT instance}

\item{transcript.ids}{A vector of transcript IDs}

\item{layer.ids}{A vector of layer IDs corresponding to transcript attributes. In
general, these are layers whose ID is prefixed 'transcript_', however formally it's
any layer where layer$parentId == 'transcript' && layer$alignment == 0, which includes
'corpus' as well as transcript attribute layers.}
}
\value{
A data frame of attribute value labels.
}
\description{
Gets transcript attribute values for given transcript IDs
}
\examples{
\dontrun{
## Get language, duration, and corpus for transcripts starting with 'BR'
attributes <- getTranscriptAttributes(labbcat.url,
            getMatchingTranscriptIds(labbcat.url, "/'BR.+'/.test(id)"),
            c('transcript_language', 'transcript_duration', 'corpus'))

}

}
\keyword{annotation}
\keyword{label}
\keyword{layer}
